/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.health.ClusterHealthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterHealthEvaluator {
    private static final String CLUSTER_INFO_KEY = ClusterHealthInfo.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(ClusterHealthEvaluator.class);
    private final Clock clock;

    public ClusterHealthEvaluator(Clock clock) {
        this.clock = clock;
    }

    public static ClusterHealthInfo getLastValidClusterHealthInfo(Map<String, String> clusterInfo) {
        LOG.debug("Getting last valid health check info");
        if (clusterInfo.containsKey(CLUSTER_INFO_KEY)) {
            return ClusterHealthInfo.deserialize(clusterInfo.get(CLUSTER_INFO_KEY));
        }
        LOG.debug("No last valid health check info");
        return null;
    }

    public static void setLastValidClusterHealthInfo(Map<String, String> clusterInfo, ClusterHealthInfo clusterHealthInfo) {
        LOG.debug("Setting last valid health check info");
        clusterInfo.put(CLUSTER_INFO_KEY, ClusterHealthInfo.serialize(clusterHealthInfo));
    }

    public static void removeLastValidClusterHealthInfo(Map<String, String> clusterInfo) {
        LOG.debug("Removing last valid health check info");
        clusterInfo.remove(CLUSTER_INFO_KEY);
    }

    public void evaluate(Configuration configuration, Map<String, String> clusterInfo, ClusterHealthInfo observedClusterHealthInfo) {
        if (ClusterHealthInfo.isValid(observedClusterHealthInfo)) {
            LOG.debug("Observed health info is valid");
            ClusterHealthInfo lastValidClusterHealthInfo = ClusterHealthEvaluator.getLastValidClusterHealthInfo(clusterInfo);
            if (lastValidClusterHealthInfo == null) {
                LOG.debug("No last valid health info, skipping health check");
                ClusterHealthEvaluator.setLastValidClusterHealthInfo(clusterInfo, observedClusterHealthInfo);
            } else {
                if (observedClusterHealthInfo.getTimeStamp() < lastValidClusterHealthInfo.getTimeStamp()) {
                    String msg = "Observed health info timestamp is less than the last valid health info timestamp, this indicates a bug...";
                    LOG.error(msg);
                    throw new IllegalStateException(msg);
                }
                if (observedClusterHealthInfo.getNumRestarts() < lastValidClusterHealthInfo.getNumRestarts()) {
                    LOG.debug("Observed health info number of restarts is less than the last valid health info number of restarts, skipping health check");
                    ClusterHealthEvaluator.setLastValidClusterHealthInfo(clusterInfo, observedClusterHealthInfo);
                } else {
                    Integer restartThreshold;
                    boolean isHealthy = true;
                    LOG.debug("Valid health info exist, checking cluster health");
                    LOG.debug("Last valid health info: {}", (Object)lastValidClusterHealthInfo);
                    LOG.debug("Observed health info: {}", (Object)observedClusterHealthInfo);
                    long timestampDiffMs = observedClusterHealthInfo.getTimeStamp() - lastValidClusterHealthInfo.getTimeStamp();
                    LOG.debug("Time difference between health infos: {}", (Object)Duration.ofMillis(timestampDiffMs));
                    Duration restartCheckWindow = (Duration)configuration.get(KubernetesOperatorConfigOptions.OPERATOR_CLUSTER_HEALTH_CHECK_RESTARTS_WINDOW);
                    long restartCheckWindowMs = restartCheckWindow.toMillis();
                    double countMultiplier = (double)restartCheckWindowMs / (double)timestampDiffMs;
                    if (countMultiplier > 1.0) {
                        countMultiplier = 1.0;
                    }
                    long numRestarts = (long)((double)(observedClusterHealthInfo.getNumRestarts() - lastValidClusterHealthInfo.getNumRestarts()) * countMultiplier);
                    LOG.debug("Calculated restart count for {} window: {}", (Object)restartCheckWindow, (Object)numRestarts);
                    if (lastValidClusterHealthInfo.getTimeStamp() < this.clock.millis() - restartCheckWindowMs) {
                        LOG.debug("Last valid health info timestamp is outside of the window");
                        ClusterHealthEvaluator.setLastValidClusterHealthInfo(clusterInfo, observedClusterHealthInfo);
                    }
                    if (numRestarts > (long)(restartThreshold = (Integer)configuration.get(KubernetesOperatorConfigOptions.OPERATOR_CLUSTER_HEALTH_CHECK_RESTARTS_THRESHOLD)).intValue()) {
                        LOG.info("Restart count hit threshold: {}", (Object)restartThreshold);
                        ClusterHealthEvaluator.setLastValidClusterHealthInfo(clusterInfo, observedClusterHealthInfo);
                        isHealthy = false;
                    }
                    lastValidClusterHealthInfo = ClusterHealthEvaluator.getLastValidClusterHealthInfo(clusterInfo);
                    lastValidClusterHealthInfo.setHealthy(isHealthy);
                    ClusterHealthEvaluator.setLastValidClusterHealthInfo(clusterInfo, lastValidClusterHealthInfo);
                }
            }
        }
    }
}

