/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer;

import io.javaoperatorsdk.operator.api.reconciler.Context;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.observer.Observer;
import org.apache.flink.kubernetes.operator.observer.ObserverContext;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.SavepointUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlinkResourceObserver<CR extends AbstractFlinkResource<?, ?>, CTX extends ObserverContext>
implements Observer<CR> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FlinkConfigManager configManager;
    protected final EventRecorder eventRecorder;

    public AbstractFlinkResourceObserver(FlinkConfigManager configManager, EventRecorder eventRecorder) {
        this.configManager = configManager;
        this.eventRecorder = eventRecorder;
    }

    @Override
    public final void observe(CR resource, Context<?> context) {
        CTX observerContext = this.getObserverContext(resource, context);
        if (!this.isResourceReadyToBeObserved(resource, context, observerContext)) {
            return;
        }
        this.observeInternal(resource, context, observerContext);
        SavepointUtils.resetTriggerIfJobNotRunning(resource, this.eventRecorder);
    }

    protected abstract CTX getObserverContext(CR var1, Context<?> var2);

    protected boolean isResourceReadyToBeObserved(CR resource, Context<?> resourceContext, CTX observerContext) {
        ReconciliationStatus reconciliationStatus = ((CommonStatus)resource.getStatus()).getReconciliationStatus();
        if (reconciliationStatus.isBeforeFirstDeployment()) {
            this.logger.debug("Skipping observe before first deployment");
            return false;
        }
        if (reconciliationStatus.getState() == ReconciliationState.ROLLING_BACK) {
            this.logger.debug("Skipping observe during rollback operation");
            return false;
        }
        if (reconciliationStatus.getState() == ReconciliationState.UPGRADING) {
            this.updateStatusToDeployedIfAlreadyUpgraded(resource, resourceContext, observerContext);
            if (reconciliationStatus.getState() == ReconciliationState.UPGRADING) {
                ReconciliationUtils.clearLastReconciledSpecIfFirstDeploy(resource);
                this.logger.debug("Skipping observe before resource is deployed during upgrade");
                return false;
            }
        }
        return true;
    }

    protected abstract void observeInternal(CR var1, Context<?> var2, CTX var3);

    protected abstract void updateStatusToDeployedIfAlreadyUpgraded(CR var1, Context<?> var2, CTX var3);
}

