/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceScopeFormat;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceScopeFormat;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;

public class KubernetesResourceNamespaceMetricGroup
extends AbstractMetricGroup<KubernetesOperatorMetricGroup> {
    private final String resourceNs;
    private final String resourceType;

    protected KubernetesResourceNamespaceMetricGroup(MetricRegistry registry, KubernetesOperatorMetricGroup parent, String[] scope, String resourceNs, String resourceType) {
        super(registry, scope, (AbstractMetricGroup)parent);
        this.resourceNs = resourceNs;
        this.resourceType = resourceType;
    }

    public KubernetesResourceMetricGroup createResourceNamespaceGroup(Configuration config, String resourceName) {
        return new KubernetesResourceMetricGroup(this.registry, this, KubernetesResourceScopeFormat.fromConfig(config).formatScope(((KubernetesOperatorMetricGroup)this.parent).namespace, ((KubernetesOperatorMetricGroup)this.parent).name, ((KubernetesOperatorMetricGroup)this.parent).hostname, this.resourceNs, resourceName, this.resourceType), resourceName);
    }

    protected final void putVariables(Map<String, String> variables) {
        variables.put(KubernetesResourceNamespaceScopeFormat.RESOURCE_NS, this.resourceNs);
        variables.put(KubernetesResourceNamespaceScopeFormat.RESOURCE_TYPE, this.resourceType);
    }

    protected final String getGroupName(CharacterFilter filter) {
        return "namespace";
    }

    protected final QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

