/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

public class KubernetesOperatorScopeFormat
extends ScopeFormat {
    public static final String NAMESPACE = KubernetesOperatorScopeFormat.asVariable((String)"namespace");
    public static final String NAME = KubernetesOperatorScopeFormat.asVariable((String)"name");

    public KubernetesOperatorScopeFormat(String format) {
        super(format, null, new String[]{NAMESPACE, NAME, SCOPE_HOST});
    }

    public String[] formatScope(String namespace, String name, String hostname) {
        String[] template = this.copyTemplate();
        String[] values = new String[]{namespace, name, hostname};
        return this.bindVariables(template, values);
    }

    public static KubernetesOperatorScopeFormat fromConfig(Configuration config) {
        String format = config.getString(KubernetesOperatorMetricOptions.SCOPE_NAMING_KUBERNETES_OPERATOR);
        return new KubernetesOperatorScopeFormat(format);
    }
}

