/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorScopeFormat;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceScopeFormat;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;

public class KubernetesOperatorMetricGroup
extends AbstractMetricGroup<AbstractMetricGroup<?>> {
    protected final String namespace;
    protected final String name;
    protected final String hostname;

    private KubernetesOperatorMetricGroup(MetricRegistry registry, String[] scope, String namespace, String name, String hostname) {
        super(registry, scope, null);
        this.namespace = namespace;
        this.name = name;
        this.hostname = hostname;
    }

    public KubernetesResourceNamespaceMetricGroup createResourceNamespaceGroup(Configuration config, Class<? extends AbstractFlinkResource> resourceClass, String resourceNs) {
        String resourceType = resourceClass.getSimpleName();
        return new KubernetesResourceNamespaceMetricGroup(this.registry, this, KubernetesResourceNamespaceScopeFormat.fromConfig(config).formatScope(this.namespace, this.name, this.hostname, resourceNs, resourceType), resourceNs, resourceType);
    }

    public static KubernetesOperatorMetricGroup create(MetricRegistry metricRegistry, Configuration configuration, String namespace, String name, String hostname) {
        return new KubernetesOperatorMetricGroup(metricRegistry, KubernetesOperatorScopeFormat.fromConfig(configuration).formatScope(namespace, name, hostname), namespace, name, hostname);
    }

    protected final void putVariables(Map<String, String> variables) {
        variables.put(KubernetesOperatorScopeFormat.NAMESPACE, this.namespace);
        variables.put(KubernetesOperatorScopeFormat.NAME, this.name);
        variables.put(ScopeFormat.SCOPE_HOST, this.hostname);
    }

    protected final String getGroupName(CharacterFilter filter) {
        return "k8soperator";
    }

    protected final QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

