/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.OperatorMetricUtils;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;

public class KubernetesClientMetrics
implements Interceptor {
    public static final String KUBE_CLIENT_GROUP = "KubeClient";
    public static final String HTTP_REQUEST_GROUP = "HttpRequest";
    public static final String HTTP_REQUEST_FAILED_GROUP = "Failed";
    public static final String HTTP_RESPONSE_GROUP = "HttpResponse";
    public static final String HTTP_RESPONSE_1XX = "1xx";
    public static final String HTTP_RESPONSE_2XX = "2xx";
    public static final String HTTP_RESPONSE_3XX = "3xx";
    public static final String HTTP_RESPONSE_4XX = "4xx";
    public static final String HTTP_RESPONSE_5XX = "5xx";
    public static final String COUNTER = "Count";
    public static final String METER = "NumPerSecond";
    public static final String HISTO = "TimeNanos";
    private final Histogram responseLatency;
    private final MetricGroup requestMetricGroup;
    private final MetricGroup failedRequestMetricGroup;
    private final MetricGroup responseMetricGroup;
    private final Counter requestCounter;
    private final Counter failedRequestCounter;
    private final Counter responseCounter;
    private final OperatorMetricUtils.SynchronizedMeterView requestRateMeter;
    private final OperatorMetricUtils.SynchronizedMeterView requestFailedRateMeter;
    private final OperatorMetricUtils.SynchronizedMeterView responseRateMeter;
    private final boolean httpResponseCodeGroupsEnabled;
    private final List<OperatorMetricUtils.SynchronizedMeterView> responseCodeGroupMeters = new ArrayList<OperatorMetricUtils.SynchronizedMeterView>(5);
    private final Map<Integer, OperatorMetricUtils.SynchronizedMeterView> responseCodeMeters = new ConcurrentHashMap<Integer, OperatorMetricUtils.SynchronizedMeterView>();
    private final Map<String, Counter> requestMethodCounter = new ConcurrentHashMap<String, Counter>();

    public KubernetesClientMetrics(MetricGroup parentGroup, FlinkOperatorConfiguration flinkOperatorConfiguration) {
        MetricGroup metricGroup = parentGroup.addGroup(KUBE_CLIENT_GROUP);
        this.requestMetricGroup = metricGroup.addGroup(HTTP_REQUEST_GROUP);
        this.failedRequestMetricGroup = this.requestMetricGroup.addGroup(HTTP_REQUEST_FAILED_GROUP);
        this.responseMetricGroup = metricGroup.addGroup(HTTP_RESPONSE_GROUP);
        this.requestCounter = OperatorMetricUtils.synchronizedCounter(this.requestMetricGroup.counter(COUNTER));
        this.failedRequestCounter = OperatorMetricUtils.synchronizedCounter(this.failedRequestMetricGroup.counter(COUNTER));
        this.responseCounter = OperatorMetricUtils.synchronizedCounter(this.responseMetricGroup.counter(COUNTER));
        this.requestRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.requestMetricGroup.meter(METER, (Meter)new MeterView(this.requestCounter)));
        this.requestFailedRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.failedRequestMetricGroup.meter(METER, (Meter)new MeterView(this.failedRequestCounter)));
        this.responseRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.responseMetricGroup.meter(METER, (Meter)new MeterView(this.responseCounter)));
        this.responseLatency = this.responseMetricGroup.histogram(HISTO, OperatorMetricUtils.createHistogram(flinkOperatorConfiguration));
        this.httpResponseCodeGroupsEnabled = flinkOperatorConfiguration.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled();
        if (this.httpResponseCodeGroupsEnabled) {
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_1XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_2XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_3XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_4XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_5XX)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.updateRequestMetrics(request);
        Response response = null;
        long startTime = System.nanoTime();
        try {
            Response response2 = response = chain.proceed(request);
            return response2;
        }
        finally {
            this.updateResponseMetrics(response, startTime);
        }
    }

    private void updateRequestMetrics(Request request) {
        this.requestRateMeter.markEvent();
        this.getCounterByRequestMethod(request.method()).inc();
    }

    private void updateResponseMetrics(Response response, long startTimeNanos) {
        long latency = System.nanoTime() - startTimeNanos;
        if (response != null) {
            this.responseRateMeter.markEvent();
            this.responseLatency.update(latency);
            this.getMeterViewByResponseCode(response.code()).markEvent();
            if (this.httpResponseCodeGroupsEnabled) {
                this.responseCodeGroupMeters.get(response.code() / 100 - 1).markEvent();
            }
        } else {
            this.requestFailedRateMeter.markEvent();
        }
    }

    private Counter getCounterByRequestMethod(String method) {
        return this.requestMethodCounter.computeIfAbsent(method, key -> OperatorMetricUtils.synchronizedCounter(this.requestMetricGroup.addGroup(key).counter(COUNTER)));
    }

    private OperatorMetricUtils.SynchronizedMeterView getMeterViewByResponseCode(int code) {
        return this.responseCodeMeters.computeIfAbsent(code, key -> this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(key.intValue())));
    }

    private OperatorMetricUtils.SynchronizedMeterView createMeterViewForMetricsGroup(MetricGroup metricGroup) {
        return OperatorMetricUtils.synchronizedMeterView((MeterView)metricGroup.meter(METER, (Meter)new MeterView(OperatorMetricUtils.synchronizedCounter(metricGroup.counter(COUNTER)))));
    }
}

