/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;

public class FlinkSessionJobMetrics
implements CustomResourceMetrics<FlinkSessionJob> {
    private final KubernetesOperatorMetricGroup parentMetricGroup;
    private final Configuration configuration;
    private final Map<String, Set<String>> sessionJobs = new ConcurrentHashMap<String, Set<String>>();
    public static final String COUNTER_NAME = "Count";

    public FlinkSessionJobMetrics(KubernetesOperatorMetricGroup parentMetricGroup, Configuration configuration) {
        this.parentMetricGroup = parentMetricGroup;
        this.configuration = configuration;
    }

    @Override
    public void onUpdate(FlinkSessionJob sessionJob) {
        this.onRemove(sessionJob);
        this.sessionJobs.computeIfAbsent(sessionJob.getMetadata().getNamespace(), ns -> {
            this.initNamespaceSessionJobCounts((String)ns);
            return ConcurrentHashMap.newKeySet();
        }).add(sessionJob.getMetadata().getName());
    }

    @Override
    public void onRemove(FlinkSessionJob sessionJob) {
        if (!this.sessionJobs.containsKey(sessionJob.getMetadata().getNamespace())) {
            return;
        }
        this.sessionJobs.get(sessionJob.getMetadata().getNamespace()).remove(sessionJob.getMetadata().getName());
    }

    private void initNamespaceSessionJobCounts(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkSessionJob.class, ns).gauge(COUNTER_NAME, () -> this.sessionJobs.get(ns).size());
    }
}

