/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.JobManagerDeploymentStatus;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;

public class FlinkDeploymentMetrics
implements CustomResourceMetrics<FlinkDeployment> {
    private final KubernetesOperatorMetricGroup parentMetricGroup;
    private final Configuration configuration;
    private final Map<String, Map<JobManagerDeploymentStatus, Set<String>>> deployments = new ConcurrentHashMap<String, Map<JobManagerDeploymentStatus, Set<String>>>();
    public static final String STATUS_GROUP_NAME = "JmDeploymentStatus";
    public static final String COUNTER_NAME = "Count";

    public FlinkDeploymentMetrics(KubernetesOperatorMetricGroup parentMetricGroup, Configuration configuration) {
        this.parentMetricGroup = parentMetricGroup;
        this.configuration = configuration;
    }

    @Override
    public void onUpdate(FlinkDeployment flinkApp) {
        this.onRemove(flinkApp);
        ((Set)this.deployments.computeIfAbsent(flinkApp.getMetadata().getNamespace(), ns -> {
            this.initNamespaceDeploymentCounts((String)ns);
            this.initNamespaceStatusCounts((String)ns);
            return this.createDeploymentStatusMap();
        }).get(((FlinkDeploymentStatus)flinkApp.getStatus()).getJobManagerDeploymentStatus())).add(flinkApp.getMetadata().getName());
    }

    @Override
    public void onRemove(FlinkDeployment flinkApp) {
        if (!this.deployments.containsKey(flinkApp.getMetadata().getNamespace())) {
            return;
        }
        this.deployments.get(flinkApp.getMetadata().getNamespace()).values().forEach(names -> names.remove(flinkApp.getMetadata().getName()));
    }

    private void initNamespaceDeploymentCounts(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).gauge(COUNTER_NAME, () -> this.deployments.get(ns).values().stream().mapToInt(Set::size).sum());
    }

    private void initNamespaceStatusCounts(String ns) {
        for (JobManagerDeploymentStatus status : JobManagerDeploymentStatus.values()) {
            this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(STATUS_GROUP_NAME).addGroup(status.toString()).gauge(COUNTER_NAME, () -> this.deployments.get(ns).get(status).size());
        }
    }

    private Map<JobManagerDeploymentStatus, Set<String>> createDeploymentStatusMap() {
        ConcurrentHashMap<JobManagerDeploymentStatus, Set<String>> statuses = new ConcurrentHashMap<JobManagerDeploymentStatus, Set<String>>();
        for (JobManagerDeploymentStatus status : JobManagerDeploymentStatus.values()) {
            statuses.put(status, ConcurrentHashMap.newKeySet());
        }
        return statuses;
    }
}

