/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import org.apache.flink.kubernetes.operator.health.HealthProbe;
import org.apache.flink.kubernetes.operator.health.OperatorHealthHandler;
import org.apache.flink.kubernetes.operator.health.OperatorHealthService;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInitializer;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.SocketChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObjectAggregator;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorHealthService.class);
    private static final int MAX_REQUEST_LENGTH = 65536;
    private final ServerBootstrap bootstrap;
    private final Channel serverChannel;

    public HttpBootstrap(HealthProbe probe, int port) throws InterruptedException {
        LOG.info("Health probe HTTP endpoint starting...");
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                pipeline.addLast(new ChannelHandler[]{new OperatorHealthHandler()});
            }
        };
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)initializer);
        this.serverChannel = this.bootstrap.bind(port).sync().channel();
        LOG.info("Health probe HTTP endpoint started on port {}", (Object)port);
    }

    public void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
        }
        if (this.bootstrap != null) {
            if (this.bootstrap.group() != null) {
                this.bootstrap.group().shutdownGracefully();
            }
            if (this.bootstrap.childGroup() != null) {
                this.bootstrap.childGroup().shutdownGracefully();
            }
        }
    }
}

