/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import org.apache.flink.annotation.Experimental;

@Experimental
public class ClusterHealthInfo {
    private long timeStamp;
    private int numRestarts;
    private boolean healthy;

    public static ClusterHealthInfo of(int numRestarts) {
        return ClusterHealthInfo.of(Clock.systemDefaultZone(), numRestarts);
    }

    public static ClusterHealthInfo of(Clock clock, int numRestarts) {
        return new ClusterHealthInfo(clock.millis(), numRestarts, true);
    }

    public static boolean isValid(ClusterHealthInfo clusterHealthInfo) {
        return clusterHealthInfo.timeStamp != 0L;
    }

    public static String serialize(ClusterHealthInfo clusterHealthInfo) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)clusterHealthInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize ClusterHealthInfo, this indicates a bug...", e);
        }
    }

    public static ClusterHealthInfo deserialize(String data) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return (ClusterHealthInfo)objectMapper.readValue(data, ClusterHealthInfo.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not deserialize ClusterHealthInfo, this indicates a bug...", e);
        }
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int getNumRestarts() {
        return this.numRestarts;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setNumRestarts(int numRestarts) {
        this.numRestarts = numRestarts;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterHealthInfo)) {
            return false;
        }
        ClusterHealthInfo other = (ClusterHealthInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getNumRestarts() != other.getNumRestarts()) {
            return false;
        }
        return this.isHealthy() == other.isHealthy();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterHealthInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        result = result * 59 + this.getNumRestarts();
        result = result * 59 + (this.isHealthy() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClusterHealthInfo(timeStamp=" + this.getTimeStamp() + ", numRestarts=" + this.getNumRestarts() + ", healthy=" + this.isHealthy() + ")";
    }

    public ClusterHealthInfo(long timeStamp, int numRestarts, boolean healthy) {
        this.timeStamp = timeStamp;
        this.numRestarts = numRestarts;
        this.healthy = healthy;
    }

    public ClusterHealthInfo() {
    }
}

