/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.status.FlinkSessionJobStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.kubernetes.operator.observer.Observer;
import org.apache.flink.kubernetes.operator.reconciler.Reconciler;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.EventSourceUtils;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class FlinkSessionJobController
implements io.javaoperatorsdk.operator.api.reconciler.Reconciler<FlinkSessionJob>,
ErrorStatusHandler<FlinkSessionJob>,
EventSourceInitializer<FlinkSessionJob>,
Cleaner<FlinkSessionJob> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSessionJobController.class);
    private final FlinkConfigManager configManager;
    private final Set<FlinkResourceValidator> validators;
    private final Reconciler<FlinkSessionJob> reconciler;
    private final Observer<FlinkSessionJob> observer;
    private final StatusRecorder<FlinkSessionJob, FlinkSessionJobStatus> statusRecorder;
    private final EventRecorder eventRecorder;

    public FlinkSessionJobController(FlinkConfigManager configManager, Set<FlinkResourceValidator> validators, Reconciler<FlinkSessionJob> reconciler, Observer<FlinkSessionJob> observer, StatusRecorder<FlinkSessionJob, FlinkSessionJobStatus> statusRecorder, EventRecorder eventRecorder) {
        this.configManager = configManager;
        this.validators = validators;
        this.reconciler = reconciler;
        this.observer = observer;
        this.statusRecorder = statusRecorder;
        this.eventRecorder = eventRecorder;
    }

    public UpdateControl<FlinkSessionJob> reconcile(FlinkSessionJob flinkSessionJob, Context context) {
        LOG.info("Starting reconciliation");
        this.statusRecorder.updateStatusFromCache(flinkSessionJob);
        FlinkSessionJob previousJob = ReconciliationUtils.clone(flinkSessionJob);
        this.observer.observe(flinkSessionJob, context);
        if (!this.validateSessionJob(flinkSessionJob, context)) {
            this.statusRecorder.patchAndCacheStatus(flinkSessionJob);
            return ReconciliationUtils.toUpdateControl(this.configManager.getOperatorConfiguration(), flinkSessionJob, previousJob, false);
        }
        try {
            this.statusRecorder.patchAndCacheStatus(flinkSessionJob);
            this.reconciler.reconcile(flinkSessionJob, context);
        }
        catch (Exception e) {
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkSessionJob, EventRecorder.Type.Warning, "SessionJobException", e.getMessage(), EventRecorder.Component.Job);
            throw new ReconciliationException(e);
        }
        this.statusRecorder.patchAndCacheStatus(flinkSessionJob);
        return ReconciliationUtils.toUpdateControl(this.configManager.getOperatorConfiguration(), flinkSessionJob, previousJob, true);
    }

    public DeleteControl cleanup(FlinkSessionJob sessionJob, Context context) {
        String msg = "Cleaning up " + FlinkSessionJob.class.getSimpleName();
        LOG.info(msg);
        this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)sessionJob, EventRecorder.Type.Normal, EventRecorder.Reason.Cleanup, EventRecorder.Component.Operator, msg);
        this.statusRecorder.removeCachedStatus(sessionJob);
        return this.reconciler.cleanup(sessionJob, context);
    }

    public ErrorStatusUpdateControl<FlinkSessionJob> updateErrorStatus(FlinkSessionJob sessionJob, Context<FlinkSessionJob> context, Exception e) {
        return ReconciliationUtils.toErrorStatusUpdateControl(sessionJob, context.getRetryInfo(), e, this.statusRecorder, this.configManager.getOperatorConfiguration());
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<FlinkSessionJob> context) {
        return EventSourceInitializer.nameEventSources((EventSource[])new EventSource[]{EventSourceUtils.getFlinkDeploymentInformerEventSource(context)});
    }

    private boolean validateSessionJob(FlinkSessionJob sessionJob, Context<?> context) {
        for (FlinkResourceValidator validator : this.validators) {
            Optional<String> validationError = validator.validateSessionJob(sessionJob, context.getSecondaryResource(FlinkDeployment.class));
            if (!validationError.isPresent()) continue;
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)sessionJob, EventRecorder.Type.Warning, EventRecorder.Reason.ValidationError, EventRecorder.Component.Operator, validationError.get());
            return ReconciliationUtils.applyValidationErrorAndResetSpec(sessionJob, validationError.get(), this.configManager.getOperatorConfiguration());
        }
        return true;
    }
}

