/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.JobManagerDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.exception.DeploymentFailedException;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.kubernetes.operator.exception.RecoveryFailureException;
import org.apache.flink.kubernetes.operator.observer.deployment.FlinkDeploymentObserverFactory;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.reconciler.deployment.ReconcilerFactory;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.EventSourceUtils;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class FlinkDeploymentController
implements Reconciler<FlinkDeployment>,
ErrorStatusHandler<FlinkDeployment>,
EventSourceInitializer<FlinkDeployment>,
Cleaner<FlinkDeployment> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkDeploymentController.class);
    private final FlinkConfigManager configManager;
    private final Set<FlinkResourceValidator> validators;
    private final ReconcilerFactory reconcilerFactory;
    private final FlinkDeploymentObserverFactory observerFactory;
    private final StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> statusRecorder;
    private final EventRecorder eventRecorder;

    public FlinkDeploymentController(FlinkConfigManager configManager, Set<FlinkResourceValidator> validators, ReconcilerFactory reconcilerFactory, FlinkDeploymentObserverFactory observerFactory, StatusRecorder<FlinkDeployment, FlinkDeploymentStatus> statusRecorder, EventRecorder eventRecorder) {
        this.configManager = configManager;
        this.validators = validators;
        this.reconcilerFactory = reconcilerFactory;
        this.observerFactory = observerFactory;
        this.statusRecorder = statusRecorder;
        this.eventRecorder = eventRecorder;
    }

    public DeleteControl cleanup(FlinkDeployment flinkApp, Context context) {
        String msg = "Cleaning up " + FlinkDeployment.class.getSimpleName();
        LOG.info(msg);
        this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkApp, EventRecorder.Type.Normal, EventRecorder.Reason.Cleanup, EventRecorder.Component.Operator, msg);
        this.statusRecorder.updateStatusFromCache(flinkApp);
        try {
            this.observerFactory.getOrCreate(flinkApp).observe(flinkApp, context);
        }
        catch (DeploymentFailedException deploymentFailedException) {
            // empty catch block
        }
        this.statusRecorder.removeCachedStatus(flinkApp);
        return this.reconcilerFactory.getOrCreate(flinkApp).cleanup(flinkApp, context);
    }

    public UpdateControl<FlinkDeployment> reconcile(FlinkDeployment flinkApp, Context context) throws Exception {
        LOG.info("Starting reconciliation");
        this.statusRecorder.updateStatusFromCache(flinkApp);
        FlinkDeployment previousDeployment = ReconciliationUtils.clone(flinkApp);
        try {
            this.observerFactory.getOrCreate(flinkApp).observe(flinkApp, context);
            if (!this.validateDeployment(flinkApp)) {
                this.statusRecorder.patchAndCacheStatus(flinkApp);
                return ReconciliationUtils.toUpdateControl(this.configManager.getOperatorConfiguration(), flinkApp, previousDeployment, false);
            }
            this.statusRecorder.patchAndCacheStatus(flinkApp);
            this.reconcilerFactory.getOrCreate(flinkApp).reconcile(flinkApp, context);
        }
        catch (RecoveryFailureException rfe) {
            this.handleRecoveryFailed(flinkApp, rfe);
        }
        catch (DeploymentFailedException dfe) {
            this.handleDeploymentFailed(flinkApp, dfe);
        }
        catch (Exception e) {
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkApp, EventRecorder.Type.Warning, "ClusterDeploymentException", e.getMessage(), EventRecorder.Component.JobManagerDeployment);
            throw new ReconciliationException(e);
        }
        LOG.info("End of reconciliation");
        this.statusRecorder.patchAndCacheStatus(flinkApp);
        return ReconciliationUtils.toUpdateControl(this.configManager.getOperatorConfiguration(), flinkApp, previousDeployment, true);
    }

    private void handleDeploymentFailed(FlinkDeployment flinkApp, DeploymentFailedException dfe) {
        LOG.error("Flink Deployment failed", (Throwable)dfe);
        ((FlinkDeploymentStatus)flinkApp.getStatus()).setJobManagerDeploymentStatus(JobManagerDeploymentStatus.ERROR);
        ((FlinkDeploymentStatus)flinkApp.getStatus()).getJobStatus().setState(JobStatus.RECONCILING.name());
        ReconciliationUtils.updateForReconciliationError(flinkApp, dfe, this.configManager.getOperatorConfiguration());
        this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkApp, EventRecorder.Type.Warning, dfe.getReason(), dfe.getMessage(), EventRecorder.Component.JobManagerDeployment);
    }

    private void handleRecoveryFailed(FlinkDeployment flinkApp, RecoveryFailureException rfe) {
        LOG.error("Flink recovery failed", (Throwable)rfe);
        ReconciliationUtils.updateForReconciliationError(flinkApp, rfe, this.configManager.getOperatorConfiguration());
        this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkApp, EventRecorder.Type.Warning, rfe.getReason(), rfe.getMessage(), EventRecorder.Component.JobManagerDeployment);
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<FlinkDeployment> context) {
        return EventSourceInitializer.nameEventSources((EventSource[])new EventSource[]{EventSourceUtils.getSessionJobInformerEventSource(context), EventSourceUtils.getDeploymentInformerEventSource(context)});
    }

    public ErrorStatusUpdateControl<FlinkDeployment> updateErrorStatus(FlinkDeployment flinkDeployment, Context<FlinkDeployment> context, Exception e) {
        return ReconciliationUtils.toErrorStatusUpdateControl(flinkDeployment, context.getRetryInfo(), e, this.statusRecorder, this.configManager.getOperatorConfiguration());
    }

    private boolean validateDeployment(FlinkDeployment deployment) {
        for (FlinkResourceValidator validator : this.validators) {
            Optional<String> validationError = validator.validateDeployment(deployment);
            if (!validationError.isPresent()) continue;
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)deployment, EventRecorder.Type.Warning, EventRecorder.Reason.ValidationError, EventRecorder.Component.Operator, validationError.get());
            return ReconciliationUtils.applyValidationErrorAndResetSpec(deployment, validationError.get(), this.configManager.getOperatorConfiguration());
        }
        return true;
    }
}

