/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.config;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.client.deployment.application.ApplicationConfiguration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.operator.api.spec.JobSpec;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.spec.Resource;
import org.apache.flink.kubernetes.operator.api.spec.UpgradeMode;
import org.apache.flink.kubernetes.operator.standalone.StandaloneKubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.operator.utils.FlinkUtils;
import org.apache.flink.runtime.jobgraph.SavepointConfigOptions;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.apache.flink.streaming.api.environment.ExecutionCheckpointingOptions;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkConfigBuilder.class);
    public static final ConfigOption<FlinkVersion> FLINK_VERSION = ConfigOptions.key((String)"$internal.flink.version").enumType(FlinkVersion.class).noDefaultValue();
    protected static final String GENERATED_FILE_PREFIX = "flink_op_generated_";
    protected static final Duration DEFAULT_CHECKPOINTING_INTERVAL = Duration.ofMinutes(5L);
    private final String namespace;
    private final String clusterId;
    private final FlinkDeploymentSpec spec;
    private final Configuration effectiveConfig;

    protected FlinkConfigBuilder(FlinkDeployment deployment, Configuration flinkConfig) {
        this(deployment.getMetadata().getNamespace(), deployment.getMetadata().getName(), (FlinkDeploymentSpec)deployment.getSpec(), flinkConfig);
    }

    protected FlinkConfigBuilder(String namespace, String clusterId, FlinkDeploymentSpec spec, Configuration flinkConfig) {
        this.namespace = namespace;
        this.clusterId = clusterId;
        this.spec = spec;
        this.effectiveConfig = new Configuration(flinkConfig);
    }

    protected FlinkConfigBuilder applyImage() {
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.spec.getImage())) {
            this.effectiveConfig.set(KubernetesConfigOptions.CONTAINER_IMAGE, (Object)this.spec.getImage());
        }
        return this;
    }

    protected FlinkConfigBuilder applyImagePullPolicy() {
        if (!StringUtils.isNullOrWhitespaceOnly((String)this.spec.getImagePullPolicy())) {
            this.effectiveConfig.set(KubernetesConfigOptions.CONTAINER_IMAGE_PULL_POLICY, (Object)KubernetesConfigOptions.ImagePullPolicy.valueOf((String)this.spec.getImagePullPolicy()));
        }
        return this;
    }

    protected FlinkConfigBuilder applyFlinkConfiguration() {
        if (this.spec.getFlinkConfiguration() != null && !this.spec.getFlinkConfiguration().isEmpty()) {
            this.spec.getFlinkConfiguration().forEach((arg_0, arg_1) -> ((Configuration)this.effectiveConfig).setString(arg_0, arg_1));
        }
        this.setDefaultConf(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, KubernetesConfigOptions.ServiceExposedType.ClusterIP);
        this.setDefaultConf(WebOptions.CANCEL_ENABLE, false);
        if (this.spec.getJob() != null) {
            this.setDefaultConf(PipelineOptions.NAME, this.clusterId);
            if (this.spec.getJob().getUpgradeMode() == UpgradeMode.LAST_STATE) {
                this.setDefaultConf(ExecutionCheckpointingOptions.CHECKPOINTING_INTERVAL, DEFAULT_CHECKPOINTING_INTERVAL);
            }
            if (this.spec.getFlinkVersion().isNewerVersionThan(FlinkVersion.v1_14)) {
                this.effectiveConfig.set(DeploymentOptions.SHUTDOWN_ON_APPLICATION_FINISH, (Object)false);
            }
            if (HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.effectiveConfig)) {
                this.setDefaultConf(DeploymentOptions.SUBMIT_FAILED_JOB_ON_APPLICATION_ERROR, true);
            }
            this.setDefaultConf(ExecutionCheckpointingOptions.EXTERNALIZED_CHECKPOINT, CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION);
        }
        this.effectiveConfig.set(FLINK_VERSION, (Object)this.spec.getFlinkVersion());
        return this;
    }

    protected FlinkConfigBuilder applyLogConfiguration() throws IOException {
        if (this.spec.getLogConfiguration() != null) {
            String confDir = FlinkConfigBuilder.createLogConfigFiles((String)this.spec.getLogConfiguration().get("log4j-console.properties"), (String)this.spec.getLogConfiguration().get("logback-console.xml"));
            this.effectiveConfig.setString(DeploymentOptionsInternal.CONF_DIR, confDir);
        }
        return this;
    }

    protected FlinkConfigBuilder applyCommonPodTemplate() throws IOException {
        if (this.spec.getPodTemplate() != null) {
            this.effectiveConfig.set(KubernetesConfigOptions.KUBERNETES_POD_TEMPLATE, (Object)FlinkConfigBuilder.createTempFile(this.spec.getPodTemplate()));
        }
        return this;
    }

    protected FlinkConfigBuilder applyIngressDomain() {
        if (this.spec.getIngress() != null) {
            this.effectiveConfig.set(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE, (Object)KubernetesConfigOptions.ServiceExposedType.ClusterIP);
        }
        return this;
    }

    protected FlinkConfigBuilder applyServiceAccount() {
        if (this.spec.getServiceAccount() != null) {
            this.effectiveConfig.set(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT, (Object)this.spec.getServiceAccount());
        }
        return this;
    }

    protected FlinkConfigBuilder applyJobManagerSpec() throws IOException {
        if (this.spec.getJobManager() != null) {
            FlinkConfigBuilder.setResource(this.spec.getJobManager().getResource(), this.effectiveConfig, true);
            FlinkConfigBuilder.setPodTemplate(this.spec.getPodTemplate(), this.spec.getJobManager().getPodTemplate(), this.effectiveConfig, true);
            if (this.spec.getJobManager().getReplicas() > 0) {
                this.effectiveConfig.set(KubernetesConfigOptions.KUBERNETES_JOBMANAGER_REPLICAS, (Object)this.spec.getJobManager().getReplicas());
            }
        }
        return this;
    }

    protected FlinkConfigBuilder applyTaskManagerSpec() throws IOException {
        if (this.spec.getTaskManager() != null) {
            FlinkConfigBuilder.setResource(this.spec.getTaskManager().getResource(), this.effectiveConfig, false);
            FlinkConfigBuilder.setPodTemplate(this.spec.getPodTemplate(), this.spec.getTaskManager().getPodTemplate(), this.effectiveConfig, false);
            if (this.spec.getTaskManager().getReplicas() != null && this.spec.getTaskManager().getReplicas() > 0) {
                this.effectiveConfig.set(StandaloneKubernetesConfigOptionsInternal.KUBERNETES_TASKMANAGER_REPLICAS, (Object)this.spec.getTaskManager().getReplicas());
            }
        }
        if (this.spec.getJob() != null && KubernetesDeploymentMode.getDeploymentMode((FlinkDeploymentSpec)this.spec) == KubernetesDeploymentMode.STANDALONE && !this.effectiveConfig.contains(StandaloneKubernetesConfigOptionsInternal.KUBERNETES_TASKMANAGER_REPLICAS)) {
            this.effectiveConfig.set(StandaloneKubernetesConfigOptionsInternal.KUBERNETES_TASKMANAGER_REPLICAS, (Object)FlinkUtils.getNumTaskManagers(this.effectiveConfig, this.getParallelism()));
        }
        return this;
    }

    protected FlinkConfigBuilder applyJobOrSessionSpec() throws URISyntaxException {
        KubernetesDeploymentMode deploymentMode = KubernetesDeploymentMode.getDeploymentMode((FlinkDeploymentSpec)this.spec);
        if (this.spec.getJob() != null) {
            JobSpec jobSpec = this.spec.getJob();
            this.effectiveConfig.set(DeploymentOptions.TARGET, (Object)KubernetesDeploymentTarget.APPLICATION.getName());
            if (jobSpec.getJarURI() != null) {
                URI uri = new URI(jobSpec.getJarURI());
                this.effectiveConfig.set(PipelineOptions.JARS, Collections.singletonList(uri.toString()));
            }
            this.effectiveConfig.set(CoreOptions.DEFAULT_PARALLELISM, (Object)this.getParallelism());
            if (jobSpec.getAllowNonRestoredState() != null) {
                this.effectiveConfig.set(SavepointConfigOptions.SAVEPOINT_IGNORE_UNCLAIMED_STATE, (Object)jobSpec.getAllowNonRestoredState());
            }
            if (jobSpec.getEntryClass() != null) {
                this.effectiveConfig.set(ApplicationConfiguration.APPLICATION_MAIN_CLASS, (Object)jobSpec.getEntryClass());
            }
            if (jobSpec.getArgs() != null) {
                this.effectiveConfig.set(ApplicationConfiguration.APPLICATION_ARGS, Arrays.asList(jobSpec.getArgs()));
            }
        } else {
            this.effectiveConfig.set(DeploymentOptions.TARGET, (Object)KubernetesDeploymentTarget.SESSION.getName());
        }
        if (deploymentMode == KubernetesDeploymentMode.STANDALONE) {
            this.effectiveConfig.set(DeploymentOptions.TARGET, (Object)"remote");
            this.effectiveConfig.set(StandaloneKubernetesConfigOptionsInternal.CLUSTER_MODE, (Object)(this.spec.getJob() == null ? StandaloneKubernetesConfigOptionsInternal.ClusterMode.SESSION : StandaloneKubernetesConfigOptionsInternal.ClusterMode.APPLICATION));
            if (this.spec.getJob() != null && this.spec.getJob().getJarURI() != null) {
                this.effectiveConfig.set(PipelineOptions.CLASSPATHS, Collections.singletonList(this.getStandaloneJarURI(this.spec.getJob())));
            }
        }
        return this;
    }

    private String getStandaloneJarURI(JobSpec jobSpec) throws URISyntaxException {
        URI uri = new URI(jobSpec.getJarURI());
        if (uri.getScheme().equals("local")) {
            uri = new URI("file", uri.getAuthority() == null ? "" : uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri.toASCIIString();
    }

    private int getParallelism() {
        if (this.spec.getTaskManager() != null && this.spec.getTaskManager().getReplicas() != null) {
            if (this.spec.getJob().getParallelism() > 0) {
                LOG.warn("Job parallelism setting is ignored as TaskManager replicas are set");
            }
            return this.spec.getTaskManager().getReplicas() * (Integer)this.effectiveConfig.get(TaskManagerOptions.NUM_TASK_SLOTS);
        }
        return this.spec.getJob().getParallelism();
    }

    protected Configuration build() {
        this.effectiveConfig.setString(KubernetesConfigOptions.NAMESPACE, this.namespace);
        this.effectiveConfig.setString(KubernetesConfigOptions.CLUSTER_ID, this.clusterId);
        return this.effectiveConfig;
    }

    public static Configuration buildFrom(String namespace, String clusterId, FlinkDeploymentSpec spec, Configuration flinkConfig) throws IOException, URISyntaxException {
        return new FlinkConfigBuilder(namespace, clusterId, spec, flinkConfig).applyFlinkConfiguration().applyLogConfiguration().applyImage().applyImagePullPolicy().applyServiceAccount().applyCommonPodTemplate().applyIngressDomain().applyJobManagerSpec().applyTaskManagerSpec().applyJobOrSessionSpec().build();
    }

    private <T> void setDefaultConf(ConfigOption<T> option, T value) {
        if (!this.effectiveConfig.contains(option)) {
            this.effectiveConfig.set(option, value);
        }
    }

    private static void setResource(Resource resource, Configuration effectiveConfig, boolean isJM) {
        if (resource != null) {
            ConfigOption cpuConfigOption;
            ConfigOption memoryConfigOption = isJM ? JobManagerOptions.TOTAL_PROCESS_MEMORY : TaskManagerOptions.TOTAL_PROCESS_MEMORY;
            ConfigOption configOption = cpuConfigOption = isJM ? KubernetesConfigOptions.JOB_MANAGER_CPU : KubernetesConfigOptions.TASK_MANAGER_CPU;
            if (resource.getMemory() != null) {
                effectiveConfig.setString(memoryConfigOption.key(), resource.getMemory());
            }
            if (resource.getCpu() != null) {
                effectiveConfig.setDouble(cpuConfigOption.key(), resource.getCpu().doubleValue());
            }
        }
    }

    private static void setPodTemplate(Pod basicPod, Pod appendPod, Configuration effectiveConfig, boolean isJM) throws IOException {
        if (basicPod == null && appendPod == null) {
            return;
        }
        if (appendPod != null) {
            ConfigOption podConfigOption = isJM ? KubernetesConfigOptions.JOB_MANAGER_POD_TEMPLATE : KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE;
            effectiveConfig.setString(podConfigOption, FlinkConfigBuilder.createTempFile(FlinkUtils.mergePodTemplates(basicPod, appendPod)));
        }
    }

    private static String createLogConfigFiles(String log4jConf, String logbackConf) throws IOException {
        File tmpDir = Files.createTempDirectory("flink_op_generated_conf_", new FileAttribute[0]).toFile();
        if (log4jConf != null) {
            File log4jConfFile = new File(tmpDir.getAbsolutePath(), "log4j-console.properties");
            Files.write(log4jConfFile.toPath(), log4jConf.getBytes(), new OpenOption[0]);
        }
        if (logbackConf != null) {
            File logbackConfFile = new File(tmpDir.getAbsolutePath(), "logback-console.xml");
            Files.write(logbackConfFile.toPath(), logbackConf.getBytes(), new OpenOption[0]);
        }
        tmpDir.deleteOnExit();
        return tmpDir.getAbsolutePath();
    }

    private static String createTempFile(Pod podTemplate) throws IOException {
        File tmp = File.createTempFile("flink_op_generated_podTemplate_", ".yaml");
        Files.write(tmp.toPath(), Serialization.asYaml((Object)podTemplate).getBytes(), new OpenOption[0]);
        tmp.deleteOnExit();
        return tmp.getAbsolutePath();
    }

    protected static void cleanupTmpFiles(Configuration configuration) {
        configuration.getOptional(KubernetesConfigOptions.KUBERNETES_POD_TEMPLATE).ifPresent(FlinkConfigBuilder::deleteSilentlyIfGenerated);
        configuration.getOptional(KubernetesConfigOptions.JOB_MANAGER_POD_TEMPLATE).ifPresent(FlinkConfigBuilder::deleteSilentlyIfGenerated);
        configuration.getOptional(KubernetesConfigOptions.TASK_MANAGER_POD_TEMPLATE).ifPresent(FlinkConfigBuilder::deleteSilentlyIfGenerated);
        configuration.getOptional(DeploymentOptionsInternal.CONF_DIR).ifPresent(FlinkConfigBuilder::deleteSilentlyIfGenerated);
    }

    private static void deleteSilentlyIfGenerated(String file) {
        try {
            File localFile = new File(file);
            if (!localFile.getName().startsWith(GENERATED_FILE_PREFIX)) {
                return;
            }
            LOG.debug("Deleting tmp config file {}", (Object)localFile);
            FileUtils.deleteFileOrDirectory((File)localFile);
        }
        catch (Exception err) {
            LOG.error("Could not clean up file " + file, (Throwable)err);
        }
    }
}

