/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.artifact;

import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.artifact.ArtifactFetcher;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpArtifactFetcher
implements ArtifactFetcher {
    public static final Logger LOG = LoggerFactory.getLogger(HttpArtifactFetcher.class);
    public static final HttpArtifactFetcher INSTANCE = new HttpArtifactFetcher();

    @Override
    public File fetch(String uri, Configuration flinkConfiguration, File targetDir) throws Exception {
        long start = System.currentTimeMillis();
        URL url = new URL(uri);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Map headers = (Map)flinkConfiguration.get(KubernetesOperatorConfigOptions.JAR_ARTIFACT_HTTP_HEADER);
        if (headers != null) {
            headers.forEach(conn::setRequestProperty);
        }
        conn.setRequestMethod("GET");
        String fileName = FilenameUtils.getName((String)url.getFile());
        File targetFile = new File(targetDir, fileName);
        try (InputStream inputStream = conn.getInputStream();){
            FileUtils.copyToFile((InputStream)inputStream, (File)targetFile);
        }
        LOG.debug("Copied file from {} to {}, cost {} ms", new Object[]{uri, targetFile, System.currentTimeMillis() - start});
        return targetFile;
    }
}

