/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.mutator.DefaultFlinkMutator;
import org.apache.flink.kubernetes.operator.mutator.FlinkResourceMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MutatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MutatorUtils.class);

    public static Set<FlinkResourceMutator> discoverMutators(FlinkConfigManager configManager) {
        Configuration conf = configManager.getDefaultConfig();
        HashSet<FlinkResourceMutator> flinkmutator = new HashSet<FlinkResourceMutator>();
        DefaultFlinkMutator defaultFlinkMutator = new DefaultFlinkMutator();
        defaultFlinkMutator.configure(conf);
        flinkmutator.add(defaultFlinkMutator);
        PluginUtils.createPluginManagerFromRootFolder((Configuration)conf).load(FlinkResourceMutator.class).forEachRemaining(mutator -> {
            LOG.info("Discovered mutator from plugin directory[{}]: {}.", (Object)System.getenv().getOrDefault("FLINK_PLUGINS_DIR", "plugins"), (Object)mutator.getClass().getName());
            mutator.configure(conf);
            flinkmutator.add((FlinkResourceMutator)mutator);
        });
        return flinkmutator;
    }
}

