/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.http.Interceptor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesClientMetrics;
import org.apache.flink.metrics.MetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesClientUtils.class);
    private static final String METRICS_INTERCEPTOR_NAME = "KubernetesClientMetrics";

    public static KubernetesClient getKubernetesClient(FlinkOperatorConfiguration operatorConfig, MetricGroup metricGroup) {
        return KubernetesClientUtils.getKubernetesClient(operatorConfig, metricGroup, null);
    }

    @VisibleForTesting
    public static KubernetesClient getKubernetesClient(FlinkOperatorConfiguration operatorConfig, MetricGroup metricGroup, Config kubernetesClientConfig) {
        KubernetesClientBuilder clientBuilder = new KubernetesClientBuilder().withConfig(kubernetesClientConfig);
        if (operatorConfig.isKubernetesClientMetricsEnabled()) {
            clientBuilder.withHttpClientBuilderConsumer(httpCLientBuilder -> httpCLientBuilder.addOrReplaceInterceptor(METRICS_INTERCEPTOR_NAME, (Interceptor)new KubernetesClientMetrics(metricGroup, operatorConfig)));
        }
        return clientBuilder.build();
    }

    public static boolean isCrdInstalled(Class<? extends HasMetadata> clazz) {
        boolean bl;
        block8: {
            KubernetesClient client = new KubernetesClientBuilder().build();
            try {
                ((KubernetesResourceList)client.resources(clazz).list()).getItems();
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOG.debug("Could not find CRD {}", (Object)clazz.getSimpleName());
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }
}

