/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.exception.DeploymentFailedException;
import org.apache.flink.kubernetes.operator.exception.FlinkResourceException;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.runtime.rest.util.RestClientException;
import org.apache.flink.util.Preconditions;

public final class FlinkResourceExceptionUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String LABELS = "labels";

    public static <R extends AbstractFlinkResource> void updateFlinkResourceException(Throwable throwable, R resource, FlinkOperatorConfiguration conf) {
        FlinkResourceException flinkResourceException = FlinkResourceExceptionUtils.getFlinkResourceException(throwable, conf);
        try {
            ((CommonStatus)resource.getStatus()).setError(FlinkResourceExceptionUtils.convertToJson(flinkResourceException));
        }
        catch (Exception e) {
            ((CommonStatus)resource.getStatus()).setError(e instanceof ReconciliationException ? e.getCause().toString() : e.toString());
        }
    }

    public static void updateFlinkStateSnapshotException(Throwable throwable, FlinkStateSnapshot resource, FlinkOperatorConfiguration conf) {
        FlinkResourceException flinkResourceException = FlinkResourceExceptionUtils.getFlinkResourceException(throwable, conf);
        try {
            ((FlinkStateSnapshotStatus)resource.getStatus()).setError(FlinkResourceExceptionUtils.convertToJson(flinkResourceException));
        }
        catch (Exception e) {
            ((FlinkStateSnapshotStatus)resource.getStatus()).setError(e instanceof ReconciliationException ? e.getCause().toString() : e.toString());
        }
    }

    private static FlinkResourceException getFlinkResourceException(Throwable throwable, FlinkOperatorConfiguration conf) {
        boolean stackTraceEnabled = conf.isExceptionStackTraceEnabled();
        int stackTraceLengthThreshold = conf.getExceptionStackTraceLengthThreshold();
        int lengthThreshold = conf.getExceptionFieldLengthThreshold();
        int throwableCountThreshold = conf.getExceptionThrowableCountThreshold();
        Map<String, String> labelMapper = conf.getExceptionLabelMapper();
        Preconditions.checkNotNull((Object)stackTraceEnabled);
        FlinkResourceException flinkResourceException = FlinkResourceExceptionUtils.convertToFlinkResourceException(throwable, stackTraceEnabled, stackTraceLengthThreshold, lengthThreshold, labelMapper);
        flinkResourceException.setThrowableList(ExceptionUtils.getThrowableList((Throwable)throwable.getCause()).stream().limit(throwableCountThreshold).map(t -> FlinkResourceExceptionUtils.convertToFlinkResourceException(t, false, stackTraceLengthThreshold, lengthThreshold, labelMapper)).collect(Collectors.toList()));
        return flinkResourceException;
    }

    private static FlinkResourceException convertToFlinkResourceException(Throwable throwable, boolean stackTraceEnabled, int stackTraceLengthThreshold, int lengthThreshold, Map<String, String> labelMapper) {
        FlinkResourceException flinkResourceException = FlinkResourceException.builder().build();
        FlinkResourceExceptionUtils.getSubstringWithMaxLength(throwable.getClass().getName(), lengthThreshold).ifPresent(flinkResourceException::setType);
        FlinkResourceExceptionUtils.getSubstringWithMaxLength(throwable.getMessage(), lengthThreshold).ifPresent(flinkResourceException::setMessage);
        if (stackTraceEnabled) {
            FlinkResourceExceptionUtils.getSubstringWithMaxLength(ExceptionUtils.getStackTrace((Throwable)throwable), stackTraceLengthThreshold).ifPresent(flinkResourceException::setStackTrace);
        }
        FlinkResourceExceptionUtils.enrichMetadata(throwable, flinkResourceException, lengthThreshold, labelMapper);
        return flinkResourceException;
    }

    public static Optional<String> getSubstringWithMaxLength(String str, int limit) {
        if (str == null) {
            return Optional.empty();
        }
        return Optional.of(str.substring(0, Math.min(str.length(), limit)));
    }

    private static void enrichMetadata(Throwable throwable, FlinkResourceException flinkResourceException, int lengthThreshold, Map<String, String> labelMapper) {
        if (flinkResourceException.getAdditionalMetadata() == null) {
            flinkResourceException.setAdditionalMetadata(new HashMap<String, Object>());
        }
        if (throwable instanceof RestClientException) {
            flinkResourceException.getAdditionalMetadata().put("httpResponseCode", ((RestClientException)throwable).getHttpResponseStatus().code());
        }
        if (throwable instanceof DeploymentFailedException) {
            FlinkResourceExceptionUtils.getSubstringWithMaxLength(((DeploymentFailedException)throwable).getReason(), lengthThreshold).ifPresent(reason -> flinkResourceException.getAdditionalMetadata().put("reason", reason));
        }
        labelMapper.entrySet().forEach(entry -> {
            Pattern pattern = Pattern.compile((String)entry.getKey());
            org.apache.flink.util.ExceptionUtils.findThrowable((Throwable)throwable, t -> pattern.matcher(Optional.ofNullable(t.getMessage()).orElse("")).find()).ifPresent(t -> FlinkResourceExceptionUtils.enrichMetadataWithLabelMapper(flinkResourceException, (String)entry.getValue()));
        });
    }

    private static void enrichMetadataWithLabelMapper(FlinkResourceException flinkResourceException, String value) {
        if (!flinkResourceException.getAdditionalMetadata().containsKey(LABELS)) {
            flinkResourceException.getAdditionalMetadata().put(LABELS, new ArrayList());
        }
        ((ArrayList)flinkResourceException.getAdditionalMetadata().get(LABELS)).add(value);
    }

    private static String convertToJson(FlinkResourceException flinkResourceException) throws JsonProcessingException {
        return objectMapper.writeValueAsString((Object)flinkResourceException);
    }
}

