/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import java.util.Optional;
import org.apache.flink.types.DeserializationException;
import org.apache.flink.util.SerializedThrowable;

public class ExceptionUtils {
    public static <T extends Throwable> Optional<T> findThrowableSerializedAware(Throwable throwable, Class<T> searchType, ClassLoader classLoader) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        Throwable t = throwable;
        while (t != null) {
            if (searchType.isAssignableFrom(t.getClass())) {
                return Optional.of((Throwable)searchType.cast(t));
            }
            if (t instanceof SerializedThrowable) {
                Throwable deserialized = ((SerializedThrowable)t).deserializeError(classLoader);
                t = deserialized == t ? new DeserializationException("Could not deserialize SerializedThrowable") : deserialized;
                continue;
            }
            t = t.getCause();
        }
        return Optional.empty();
    }
}

