/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.SecondaryToPrimaryMapper;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerEventSource;
import io.javaoperatorsdk.operator.processing.event.source.informer.Mappers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkStateSnapshotSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobKind;
import org.apache.flink.kubernetes.operator.api.spec.JobReference;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.apache.flink.kubernetes.operator.controller.FlinkDeploymentController;
import org.apache.flink.kubernetes.operator.controller.FlinkSessionJobController;
import org.apache.flink.kubernetes.operator.utils.FlinkStateSnapshotUtils;

public class EventSourceUtils {
    private static final String FLINK_DEPLOYMENT_IDX = FlinkDeploymentController.class.getName();
    private static final String FLINK_SESSIONJOB_IDX = FlinkSessionJobController.class.getName();
    private static final String FLINK_STATE_SNAPSHOT_IDX = FlinkStateSnapshot.class.getName();

    public static <T extends AbstractFlinkResource<?, ?>> InformerEventSource<FlinkStateSnapshot, T> getStateSnapshotForFlinkResourceInformerEventSource(EventSourceContext<T> context) {
        String labelFilters = Stream.of(SnapshotTriggerType.PERIODIC, SnapshotTriggerType.UPGRADE).map(Enum::name).collect(Collectors.joining(","));
        String labelSelector = String.format("%s in (%s)", "snapshot.trigger-type", labelFilters);
        InformerConfiguration configuration = InformerConfiguration.from(FlinkStateSnapshot.class, context).withLabelSelector(labelSelector).withSecondaryToPrimaryMapper(snapshot -> {
            JobReference jobRef = ((FlinkStateSnapshotSpec)snapshot.getSpec()).getJobReference();
            if (jobRef == null || jobRef.getName() == null) {
                return Collections.emptySet();
            }
            return Set.of(new ResourceID(((FlinkStateSnapshotSpec)snapshot.getSpec()).getJobReference().getName(), snapshot.getMetadata().getNamespace()));
        }).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static InformerEventSource<Deployment, FlinkDeployment> getDeploymentInformerEventSource(EventSourceContext<FlinkDeployment> context) {
        String labelSelector = Map.of("component", "jobmanager").entrySet().stream().map(Object::toString).collect(Collectors.joining(","));
        InformerConfiguration configuration = InformerConfiguration.from(Deployment.class, context).withLabelSelector(labelSelector).withSecondaryToPrimaryMapper(Mappers.fromLabel((String)"app")).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static InformerEventSource<FlinkSessionJob, FlinkDeployment> getSessionJobInformerEventSource(EventSourceContext<FlinkDeployment> context) {
        context.getPrimaryCache().addIndexer(FLINK_DEPLOYMENT_IDX, flinkDeployment -> List.of(EventSourceUtils.indexKey(flinkDeployment.getMetadata().getName(), flinkDeployment.getMetadata().getNamespace())));
        InformerConfiguration configuration = InformerConfiguration.from(FlinkSessionJob.class, context).withSecondaryToPrimaryMapper(sessionJob -> context.getPrimaryCache().byIndex(FLINK_DEPLOYMENT_IDX, EventSourceUtils.indexKey(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace())).stream().map(ResourceID::fromResource).collect(Collectors.toSet())).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static InformerEventSource<FlinkDeployment, FlinkSessionJob> getFlinkDeploymentInformerEventSource(EventSourceContext<FlinkSessionJob> context) {
        context.getPrimaryCache().addIndexer(FLINK_SESSIONJOB_IDX, sessionJob -> List.of(EventSourceUtils.indexKey(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace())));
        InformerConfiguration configuration = InformerConfiguration.from(FlinkDeployment.class, context).withSecondaryToPrimaryMapper(flinkDeployment -> context.getPrimaryCache().byIndex(FLINK_SESSIONJOB_IDX, EventSourceUtils.indexKey(flinkDeployment.getMetadata().getName(), flinkDeployment.getMetadata().getNamespace())).stream().map(ResourceID::fromResource).collect(Collectors.toSet())).withPrimaryToSecondaryMapper(sessionJob -> Set.of(new ResourceID(((FlinkSessionJobSpec)sessionJob.getSpec()).getDeploymentName(), sessionJob.getMetadata().getNamespace()))).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        return new InformerEventSource(configuration, context);
    }

    public static EventSource[] getFlinkStateSnapshotInformerEventSources(EventSourceContext<FlinkStateSnapshot> context) {
        context.getPrimaryCache().addIndexer(FLINK_STATE_SNAPSHOT_IDX, savepoint -> {
            if (((FlinkStateSnapshotSpec)savepoint.getSpec()).getJobReference() == null || ((FlinkStateSnapshotSpec)savepoint.getSpec()).getJobReference().getName() == null) {
                return Collections.emptyList();
            }
            return List.of(EventSourceUtils.indexKey(((FlinkStateSnapshotSpec)savepoint.getSpec()).getJobReference().toString(), savepoint.getMetadata().getNamespace()));
        });
        InformerConfiguration configurationFlinkSessionJob = InformerConfiguration.from(FlinkSessionJob.class, context).withSecondaryToPrimaryMapper(EventSourceUtils.getSnapshotPrimaryMapper(context)).withPrimaryToSecondaryMapper(snapshot -> {
            if (!JobKind.FLINK_SESSION_JOB.equals((Object)((FlinkStateSnapshotSpec)snapshot.getSpec()).getJobReference().getKind())) {
                return Set.of();
            }
            return Set.of(FlinkStateSnapshotUtils.getSnapshotJobReferenceResourceId(snapshot));
        }).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        InformerEventSource flinkSessionJobEventSource = new InformerEventSource(configurationFlinkSessionJob, context);
        InformerConfiguration configurationFlinkDeployment = InformerConfiguration.from(FlinkDeployment.class, context).withSecondaryToPrimaryMapper(EventSourceUtils.getSnapshotPrimaryMapper(context)).withPrimaryToSecondaryMapper(snapshot -> {
            if (JobKind.FLINK_SESSION_JOB.equals((Object)((FlinkStateSnapshotSpec)snapshot.getSpec()).getJobReference().getKind())) {
                ResourceID resourceId = FlinkStateSnapshotUtils.getSnapshotJobReferenceResourceId(snapshot);
                FlinkSessionJob flinkSessionJob = (FlinkSessionJob)flinkSessionJobEventSource.get(resourceId).orElseThrow();
                return Set.of(new ResourceID(((FlinkSessionJobSpec)flinkSessionJob.getSpec()).getDeploymentName(), flinkSessionJob.getMetadata().getNamespace()));
            }
            return Set.of(FlinkStateSnapshotUtils.getSnapshotJobReferenceResourceId(snapshot));
        }).withNamespacesInheritedFromController(context).followNamespaceChanges(true).build();
        InformerEventSource flinkDeploymentEventSource = new InformerEventSource(configurationFlinkDeployment, context);
        return new EventSource[]{flinkSessionJobEventSource, flinkDeploymentEventSource};
    }

    private static <T extends AbstractFlinkResource<?, ?>> SecondaryToPrimaryMapper<T> getSnapshotPrimaryMapper(EventSourceContext<FlinkStateSnapshot> ctx) {
        return flinkResource -> ctx.getPrimaryCache().byIndex(FLINK_STATE_SNAPSHOT_IDX, EventSourceUtils.indexKey(flinkResource.getMetadata().getName(), flinkResource.getMetadata().getNamespace())).stream().map(ResourceID::fromResource).collect(Collectors.toSet());
    }

    private static String indexKey(String name, String namespace) {
        return name + "#" + namespace;
    }
}

