/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EnvUtils.class);
    public static final String ENV_KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    public static final String ENV_WEBHOOK_KEYSTORE_FILE = "WEBHOOK_KEYSTORE_FILE";
    public static final String ENV_WEBHOOK_KEYSTORE_PASSWORD = "WEBHOOK_KEYSTORE_PASSWORD";
    public static final String ENV_WEBHOOK_KEYSTORE_TYPE = "WEBHOOK_KEYSTORE_TYPE";
    public static final String ENV_WEBHOOK_SERVER_PORT = "WEBHOOK_SERVER_PORT";
    public static final String ENV_CONF_OVERRIDE_DIR = "CONF_OVERRIDE_DIR";
    public static final String ENV_HOSTNAME = "HOSTNAME";
    public static final String ENV_OPERATOR_NAME = "OPERATOR_NAME";
    public static final String ENV_OPERATOR_NAMESPACE = "OPERATOR_NAMESPACE";
    public static final String ENV_WATCH_NAMESPACES = "WATCH_NAMESPACES";
    public static final String ENV_OPERATOR_KEYSTORE_PASSWORD = "OPERATOR_KEYSTORE_PASSWORD";
    public static final String ENV_OPERATOR_KEYSTORE_PATH = "OPERATOR_KEYSTORE_PATH";
    public static final String ENV_OPERATOR_TRUSTSTORE_PATH = "OPERATOR_TRUSTSTORE_PATH";
    private static final String PROP_FILE = ".flink-kubernetes-operator.version.properties";
    private static final String FAIL_MESSAGE = "The file .flink-kubernetes-operator.version.properties has not been generated correctly. You MUST run 'mvn generate-sources' in the flink-kubernetes-operator module.";
    private static final String DEFAULT_TIME_STRING = "1970-01-01T00:00:00+0000";

    public static Optional<String> get(String key) {
        return Optional.ofNullable((String)StringUtils.getIfBlank((CharSequence)System.getenv().get(key), () -> null));
    }

    public static String getOrDefault(String key, String defaultValue) {
        return System.getenv().getOrDefault(key, defaultValue);
    }

    public static String getRequired(String key) {
        return EnvUtils.get(key).orElseThrow(() -> new NoSuchElementException("Environments: " + key + " cannot be empty"));
    }

    public static void logEnvironmentInfo(Logger log, String componentName, String[] commandLineArgs) {
        if (log.isInfoEnabled()) {
            Properties properties = new Properties();
            try (InputStream propFile = EnvUtils.class.getClassLoader().getResourceAsStream(PROP_FILE);){
                if (propFile != null) {
                    properties.load(propFile);
                }
            }
            catch (IOException e) {
                LOG.info("Cannot determine code revision: Unable to read version property file.: {}", (Object)e.getMessage());
            }
            String javaHome = System.getenv("JAVA_HOME");
            String arch = System.getProperty("os.arch");
            long maxHeapMegabytes = EnvironmentInformation.getMaxJvmHeapMemory() >>> 20;
            log.info("--------------------------------------------------------------------------------");
            log.info(" Starting " + componentName + " (Version: " + EnvUtils.getProperty(properties, "project.version", "<unknown>") + ", Flink Version: " + EnvironmentInformation.getVersion() + ", Rev:" + EnvUtils.getProperty(properties, "git.commit.id.abbrev", "DeadD0d0") + ", Date:" + EnvUtils.getGitCommitTimeString(properties) + ")");
            log.info(" OS current user: " + System.getProperty("user.name"));
            log.info(" JVM: " + EnvironmentInformation.getJvmVersion());
            log.info(" Arch: " + arch);
            log.info(" Maximum heap size: " + maxHeapMegabytes + " MiBytes");
            log.info(" JAVA_HOME: " + (javaHome == null ? "(not set)" : javaHome));
            String[] options = EnvironmentInformation.getJvmStartupOptionsArray();
            if (options.length == 0) {
                log.info(" JVM Options: (none)");
            } else {
                log.info(" JVM Options:");
                for (String s : options) {
                    log.info("    " + s);
                }
            }
            if (commandLineArgs == null || commandLineArgs.length == 0) {
                log.info(" Program Arguments: (none)");
            } else {
                log.info(" Program Arguments:");
                for (String s : commandLineArgs) {
                    if (GlobalConfiguration.isSensitive((String)s)) {
                        log.info("    ****** (sensitive information)");
                        continue;
                    }
                    log.info("    " + s);
                }
            }
            log.info(" Classpath: " + System.getProperty("java.class.path"));
            log.info("--------------------------------------------------------------------------------");
        }
    }

    private static String getGitCommitTimeString(Properties properties) {
        try {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("Europe/Berlin")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ").parse((CharSequence)EnvUtils.getProperty(properties, "git.commit.time", DEFAULT_TIME_STRING), Instant::from));
        }
        catch (DateTimeParseException e) {
            LOG.error("{} : {}", (Object)FAIL_MESSAGE, (Object)e);
            throw new IllegalStateException(FAIL_MESSAGE, e);
        }
    }

    private static String getProperty(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null || value.charAt(0) == '$') {
            return defaultValue;
        }
        return value;
    }
}

