/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.utils;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigOptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigOptionUtils.class);

    public static <T extends Comparable<T>> T getValueWithThreshold(Configuration config, ConfigOption<T> configOption, T configThreshold) {
        Comparable configValue = (Comparable)config.get(configOption);
        if (configThreshold != null && configValue.compareTo(configThreshold) > 0) {
            LOG.warn("Uses the config threshold [{}] instead of the config value [{}] of '{}'.", new Object[]{configThreshold, configValue, configOption.key()});
            return configThreshold;
        }
        return (T)configValue;
    }
}

