/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobSpec;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.observer.CheckpointFetchResult;
import org.apache.flink.kubernetes.operator.observer.CheckpointStatsResult;
import org.apache.flink.kubernetes.operator.observer.SavepointFetchResult;
import org.apache.flink.kubernetes.operator.service.CheckpointHistoryWrapper;
import org.apache.flink.kubernetes.operator.service.SuspendMode;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobmaster.JobResult;

public interface FlinkService {
    public KubernetesClient getKubernetesClient();

    public void submitApplicationCluster(JobSpec var1, Configuration var2, boolean var3) throws Exception;

    public boolean isHaMetadataAvailable(Configuration var1);

    public boolean atLeastOneCheckpoint(Configuration var1);

    public void submitSessionCluster(Configuration var1) throws Exception;

    public JobID submitJobToSessionCluster(ObjectMeta var1, FlinkSessionJobSpec var2, JobID var3, Configuration var4, @Nullable String var5) throws Exception;

    public boolean isJobManagerPortReady(Configuration var1);

    public Optional<JobStatusMessage> getJobStatus(Configuration var1, JobID var2) throws Exception;

    public JobResult requestJobResult(Configuration var1, JobID var2) throws Exception;

    public CancelResult cancelJob(FlinkDeployment var1, SuspendMode var2, Configuration var3) throws Exception;

    public void deleteClusterDeployment(ObjectMeta var1, FlinkDeploymentStatus var2, Configuration var3, boolean var4);

    public CancelResult cancelSessionJob(FlinkSessionJob var1, SuspendMode var2, Configuration var3) throws Exception;

    public String triggerSavepoint(String var1, SavepointFormatType var2, String var3, Configuration var4) throws Exception;

    public String triggerCheckpoint(String var1, CheckpointType var2, Configuration var3) throws Exception;

    public Optional<Savepoint> getLastCheckpoint(JobID var1, Configuration var2);

    public SavepointFetchResult fetchSavepointInfo(String var1, String var2, Configuration var3);

    public CheckpointFetchResult fetchCheckpointInfo(String var1, String var2, Configuration var3);

    public CheckpointStatsResult fetchCheckpointStats(String var1, Long var2, Configuration var3);

    public Tuple2<Optional<CheckpointHistoryWrapper.CompletedCheckpointInfo>, Optional<CheckpointHistoryWrapper.PendingCheckpointInfo>> getCheckpointInfo(JobID var1, Configuration var2) throws Exception;

    public void disposeSavepoint(String var1, Configuration var2) throws Exception;

    public Map<String, String> getClusterInfo(Configuration var1, @Nullable String var2) throws Exception;

    public PodList getJmPodList(FlinkDeployment var1, Configuration var2);

    public boolean scale(FlinkResourceContext<?> var1, Configuration var2) throws Exception;

    public Map<String, String> getMetrics(Configuration var1, String var2, List<String> var3) throws Exception;

    public RestClusterClient<String> getClusterClient(Configuration var1) throws Exception;

    public static class CancelResult {
        boolean pending;
        String savepointPath;

        public static CancelResult completed(String path) {
            return new CancelResult(false, path);
        }

        public static CancelResult pending() {
            return new CancelResult(true, null);
        }

        public Optional<String> getSavepointPath() {
            return Optional.ofNullable(this.savepointPath);
        }

        public CancelResult(boolean pending, String savepointPath) {
            this.pending = pending;
            this.savepointPath = savepointPath;
        }

        public boolean isPending() {
            return this.pending;
        }
    }
}

