/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.service;

import java.util.Optional;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CheckpointHistoryWrapper
implements ResponseBody {
    @JsonProperty(value="latest")
    private ObjectNode latestCheckpoints;
    @JsonProperty(value="history")
    private ArrayNode history;

    public Optional<PendingCheckpointInfo> getInProgressCheckpoint() {
        if (this.history == null || this.history.isEmpty()) {
            return Optional.empty();
        }
        JsonNode lastCp = this.history.get(0);
        CheckpointStatsStatus status = CheckpointStatsStatus.valueOf((String)lastCp.get("status").asText());
        if (status.isInProgress()) {
            return Optional.of(new PendingCheckpointInfo(lastCp.get("id").asLong(), lastCp.get("trigger_timestamp").asLong()));
        }
        return Optional.empty();
    }

    public Optional<CompletedCheckpointInfo> getLatestCompletedCheckpoint() {
        if (this.latestCheckpoints == null) {
            return Optional.empty();
        }
        CompletedCheckpointInfo latestCheckpoint = this.getCheckpointInfo("restored").orElse(null);
        CompletedCheckpointInfo completed = this.getCheckpointInfo("completed").orElse(null);
        if (latestCheckpoint == null || completed != null && completed.id > latestCheckpoint.id) {
            latestCheckpoint = completed;
        }
        CompletedCheckpointInfo savepoint = this.getCheckpointInfo("savepoint").orElse(null);
        if (latestCheckpoint == null || savepoint != null && savepoint.id > latestCheckpoint.id) {
            latestCheckpoint = savepoint;
        }
        return Optional.ofNullable(latestCheckpoint);
    }

    private Optional<CompletedCheckpointInfo> getCheckpointInfo(String field) {
        return Optional.ofNullable(this.latestCheckpoints.get(field)).filter(checkpoint -> checkpoint.has("id") && checkpoint.has("external_path")).map(checkpoint -> new CompletedCheckpointInfo(checkpoint.get("id").asLong(), checkpoint.get("external_path").asText(), this.getCheckpointTimestamp((JsonNode)checkpoint)));
    }

    private long getCheckpointTimestamp(JsonNode checkpoint) {
        if (checkpoint.has("trigger_timestamp")) {
            return checkpoint.get("trigger_timestamp").asLong();
        }
        return checkpoint.get("restore_timestamp").asLong();
    }

    public ObjectNode getLatestCheckpoints() {
        return this.latestCheckpoints;
    }

    public ArrayNode getHistory() {
        return this.history;
    }

    public void setLatestCheckpoints(ObjectNode latestCheckpoints) {
        this.latestCheckpoints = latestCheckpoints;
    }

    public void setHistory(ArrayNode history) {
        this.history = history;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointHistoryWrapper)) {
            return false;
        }
        CheckpointHistoryWrapper other = (CheckpointHistoryWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectNode this$latestCheckpoints = this.getLatestCheckpoints();
        ObjectNode other$latestCheckpoints = other.getLatestCheckpoints();
        if (this$latestCheckpoints == null ? other$latestCheckpoints != null : !this$latestCheckpoints.equals(other$latestCheckpoints)) {
            return false;
        }
        ArrayNode this$history = this.getHistory();
        ArrayNode other$history = other.getHistory();
        return !(this$history == null ? other$history != null : !this$history.equals(other$history));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointHistoryWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectNode $latestCheckpoints = this.getLatestCheckpoints();
        result = result * 59 + ($latestCheckpoints == null ? 43 : $latestCheckpoints.hashCode());
        ArrayNode $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : $history.hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointHistoryWrapper(latestCheckpoints=" + this.getLatestCheckpoints() + ", history=" + this.getHistory() + ")";
    }

    public static final class PendingCheckpointInfo {
        private final long id;
        private final long timestamp;

        public PendingCheckpointInfo(long id, long timestamp) {
            this.id = id;
            this.timestamp = timestamp;
        }

        public long getId() {
            return this.id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingCheckpointInfo)) {
                return false;
            }
            PendingCheckpointInfo other = (PendingCheckpointInfo)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.getTimestamp() == other.getTimestamp();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            return result;
        }

        public String toString() {
            return "CheckpointHistoryWrapper.PendingCheckpointInfo(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }

    public static final class CompletedCheckpointInfo {
        private final long id;
        private final String externalPointer;
        private final long timestamp;

        public CompletedCheckpointInfo(long id, String externalPointer, long timestamp) {
            this.id = id;
            this.externalPointer = externalPointer;
            this.timestamp = timestamp;
        }

        public long getId() {
            return this.id;
        }

        public String getExternalPointer() {
            return this.externalPointer;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompletedCheckpointInfo)) {
                return false;
            }
            CompletedCheckpointInfo other = (CompletedCheckpointInfo)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$externalPointer = this.getExternalPointer();
            String other$externalPointer = other.getExternalPointer();
            return !(this$externalPointer == null ? other$externalPointer != null : !this$externalPointer.equals(other$externalPointer));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $externalPointer = this.getExternalPointer();
            result = result * 59 + ($externalPointer == null ? 43 : $externalPointer.hashCode());
            return result;
        }

        public String toString() {
            return "CheckpointHistoryWrapper.CompletedCheckpointInfo(id=" + this.getId() + ", externalPointer=" + this.getExternalPointer() + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

