/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.resources;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.kubernetes.operator.resources.KubernetesResource;

public class KubernetesNodeResourceInfo {
    private String name;
    private String nodeGroup;
    private KubernetesResource cpu;
    private KubernetesResource memory;

    public boolean tryReserve(double cpuAmount, MemorySize memoryAmount) {
        if (this.cpu.getFree() >= cpuAmount && this.memory.getFree() >= (double)memoryAmount.getBytes()) {
            this.cpu.setPending(this.cpu.getPending() + cpuAmount);
            this.memory.setPending(this.memory.getPending() + (double)memoryAmount.getBytes());
            return true;
        }
        return false;
    }

    public void commitPending() {
        this.cpu.commitPending();
        this.memory.commitPending();
    }

    public void resetPending() {
        this.cpu.setPending(0.0);
        this.memory.setPending(0.0);
    }

    public boolean tryRelease(double cpuAmount, double memoryAmount) {
        if (this.cpu.getUsed() >= cpuAmount && this.memory.getUsed() >= memoryAmount) {
            this.cpu.release(cpuAmount);
            this.memory.release(memoryAmount);
            return true;
        }
        return false;
    }

    public String toString() {
        return "KubernetesNodeResourceInfo{name='" + this.name + "', cpu=" + this.cpu + ", memory=" + this.memory + "}";
    }

    public KubernetesNodeResourceInfo(String name, String nodeGroup, KubernetesResource cpu, KubernetesResource memory) {
        this.name = name;
        this.nodeGroup = nodeGroup;
        this.cpu = cpu;
        this.memory = memory;
    }

    public String getName() {
        return this.name;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public KubernetesResource getCpu() {
        return this.cpu;
    }

    public KubernetesResource getMemory() {
        return this.memory;
    }
}

