/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.resources;

import java.time.Instant;
import java.util.List;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.kubernetes.operator.resources.KubernetesNodeResourceInfo;

public class ClusterResourceView {
    private final Instant creationTime = Instant.now();
    private final List<KubernetesNodeResourceInfo> nodes;

    public boolean tryReserve(double cpu, MemorySize memory) {
        for (KubernetesNodeResourceInfo node : this.nodes) {
            if (!node.tryReserve(cpu, memory)) continue;
            return true;
        }
        return false;
    }

    public void release(double cpu, MemorySize memory) {
        for (KubernetesNodeResourceInfo node : this.nodes) {
            if (!node.tryRelease(cpu, memory.getBytes())) continue;
            return;
        }
    }

    public void commit() {
        for (KubernetesNodeResourceInfo node : this.nodes) {
            node.commitPending();
        }
    }

    public void cancelPending() {
        for (KubernetesNodeResourceInfo node : this.nodes) {
            node.resetPending();
        }
    }

    public String toString() {
        return "ClusterResourceView{creationTime=" + this.creationTime + ", nodes=" + this.nodes + "}";
    }

    public ClusterResourceView(List<KubernetesNodeResourceInfo> nodes) {
        this.nodes = nodes;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public List<KubernetesNodeResourceInfo> getNodes() {
        return this.nodes;
    }
}

