/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.resources;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.autoscaler.resources.ResourceCheck;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.resources.ClusterResourceView;
import org.apache.flink.kubernetes.operator.resources.KubernetesNodeResourceInfo;
import org.apache.flink.kubernetes.operator.resources.KubernetesResource;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterResourceManager
implements ResourceCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterResourceManager.class);
    static final String CLUSTER_AUTOSCALER_CONFIG_MAP = "cluster-autoscaler-status";
    static final String LABEL_NODE_GROUP = "eks.amazonaws.com/nodegroup";
    private final Duration refreshInterval;
    private final KubernetesClient kubernetesClient;
    @VisibleForTesting
    ClusterResourceView clusterResourceView;

    public static ClusterResourceManager of(Configuration config, KubernetesClient client) {
        return new ClusterResourceManager((Duration)config.get(KubernetesOperatorConfigOptions.REFRESH_CLUSTER_RESOURCE_VIEW), client);
    }

    public ClusterResourceManager(Duration refreshInterval, KubernetesClient kubernetesClient) {
        this.refreshInterval = refreshInterval;
        this.kubernetesClient = kubernetesClient;
    }

    public synchronized boolean trySchedule(int currentInstances, int newInstances, double cpuPerInstance, MemorySize memoryPerInstance) {
        if (this.refreshInterval.isNegative()) {
            return true;
        }
        if (this.shouldRefreshView(this.clusterResourceView, this.refreshInterval)) {
            try {
                this.clusterResourceView = ClusterResourceManager.createResourceView(this.kubernetesClient);
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 403) {
                    LOG.warn("No permission to retrieve node resource usage. Resource check disabled.");
                    return true;
                }
                throw e;
            }
        }
        return ClusterResourceManager.trySchedule(this.clusterResourceView, currentInstances, newInstances, cpuPerInstance, memoryPerInstance);
    }

    private static boolean trySchedule(ClusterResourceView resourceView, int currentInstances, int newInstances, double cpuPerInstance, MemorySize memoryPerInstance) {
        int i;
        resourceView.cancelPending();
        for (i = 0; i < currentInstances; ++i) {
            resourceView.release(cpuPerInstance, memoryPerInstance);
        }
        for (i = 0; i < newInstances; ++i) {
            if (resourceView.tryReserve(cpuPerInstance, memoryPerInstance)) continue;
            return false;
        }
        resourceView.commit();
        return true;
    }

    private boolean shouldRefreshView(ClusterResourceView clusterResourceView, Duration refreshInterval) {
        return clusterResourceView == null || Instant.now().isAfter(clusterResourceView.getCreationTime().plus(refreshInterval));
    }

    private static ClusterResourceView createResourceView(KubernetesClient kubernetesClient) {
        ArrayList<KubernetesNodeResourceInfo> nodes = new ArrayList<KubernetesNodeResourceInfo>();
        for (Node item : ((NodeList)kubernetesClient.nodes().list()).getItems()) {
            String nodeName = item.getMetadata().getName();
            String nodeGroup = (String)item.getMetadata().getLabels().get(LABEL_NODE_GROUP);
            Map usage = kubernetesClient.top().nodes().metrics(nodeName).getUsage();
            Map allocatable = item.getStatus().getAllocatable();
            KubernetesResource cpuInfo = ClusterResourceManager.getResourceInfo("cpu", allocatable, usage);
            KubernetesResource memInfo = ClusterResourceManager.getResourceInfo("memory", allocatable, usage);
            nodes.add(new KubernetesNodeResourceInfo(nodeName, nodeGroup, cpuInfo, memInfo));
        }
        try {
            ClusterResourceManager.addClusterAutoscalableNodes(kubernetesClient, nodes);
        }
        catch (ClusterAutoscalerUnavailableException e) {
            LOG.info("No cluster autoscaler information available: {}", (Object)e.getMessage());
        }
        return new ClusterResourceView(nodes);
    }

    private static void addClusterAutoscalableNodes(KubernetesClient kubernetesClient, List<KubernetesNodeResourceInfo> nodes) throws ClusterAutoscalerUnavailableException {
        Map<String, Integer> nodeGroupsWithMaxSize = ClusterResourceManager.getMaxClusterSizeByNodeGroup(kubernetesClient);
        HashMap<String, List> nodeGroupsWithCurrentSize = new HashMap<String, List>();
        for (KubernetesNodeResourceInfo kubernetesNodeResourceInfo : nodes) {
            List nodeGroupInfos = nodeGroupsWithCurrentSize.computeIfAbsent(kubernetesNodeResourceInfo.getNodeGroup(), key -> new ArrayList());
            nodeGroupInfos.add(kubernetesNodeResourceInfo);
        }
        for (Map.Entry entry : nodeGroupsWithMaxSize.entrySet()) {
            int nodeGroupCurrentSize;
            String nodeGroup = (String)entry.getKey();
            int nodeGroupMaxSize = (Integer)entry.getValue();
            List nodeGroupNodes = (List)nodeGroupsWithCurrentSize.get(nodeGroup);
            if (nodeGroupNodes == null) continue;
            for (int i = nodeGroupCurrentSize = nodeGroupNodes.size(); i < nodeGroupMaxSize; ++i) {
                KubernetesNodeResourceInfo exmplaryNode = (KubernetesNodeResourceInfo)nodeGroupNodes.get(0);
                nodes.add(new KubernetesNodeResourceInfo("future-node-" + i, exmplaryNode.getNodeGroup(), new KubernetesResource(exmplaryNode.getCpu().getAllocatable(), 0.0), new KubernetesResource(exmplaryNode.getMemory().getAllocatable(), 0.0)));
            }
        }
    }

    private static Map<String, Integer> getMaxClusterSizeByNodeGroup(KubernetesClient kubernetesClient) throws ClusterAutoscalerUnavailableException {
        ConfigMap configMap = new ConfigMap();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName(CLUSTER_AUTOSCALER_CONFIG_MAP);
        metadata.setNamespace("kube-system");
        configMap.setMetadata(metadata);
        configMap = (ConfigMap)((Resource)kubernetesClient.configMaps().resource((Object)configMap)).get();
        if (configMap == null) {
            LOG.info("ConfigMap {} not found", (Object)CLUSTER_AUTOSCALER_CONFIG_MAP);
            throw new ClusterAutoscalerUnavailableException("ConfigMap not found cluster-autoscaler-status");
        }
        String status = (String)configMap.getData().get("status");
        if (status == null) {
            throw new RuntimeException("status field not found in cluster-autoscaler-status");
        }
        Matcher matcher = Pattern.compile("Name:\\s*(\\S+)\n.*\n.*maxSize=(\\d+)").matcher(status);
        HashMap<String, Integer> nodeGroupsBySize = new HashMap<String, Integer>();
        while (matcher.find()) {
            String nodeGroupName = matcher.group(1);
            int numNodes = Integer.parseInt(matcher.group(2));
            Integer existingValue = nodeGroupsBySize.put(nodeGroupName, numNodes);
            LOG.debug("Extracted nodeGroup {} maxSize: {}", (Object)nodeGroupName, nodeGroupsBySize);
            Preconditions.checkState((existingValue == null ? 1 : 0) != 0, (String)"NodeGroup %s found twice", (Object[])new Object[]{nodeGroupName});
        }
        if (nodeGroupsBySize.isEmpty()) {
            throw new RuntimeException("Cluster size could not be determined");
        }
        return nodeGroupsBySize;
    }

    @VisibleForTesting
    void refresh() {
        this.clusterResourceView = null;
    }

    private static KubernetesResource getResourceInfo(String type, Map<String, Quantity> allocatableMap, Map<String, Quantity> usageMap) {
        Quantity allocatableQuantity = (Quantity)Preconditions.checkNotNull((Object)allocatableMap.get(type));
        Quantity usageQuantity = (Quantity)Preconditions.checkNotNull((Object)usageMap.get(type));
        double allocatable = allocatableQuantity.getNumericalAmount().doubleValue();
        double usage = usageQuantity.getNumericalAmount().doubleValue();
        return new KubernetesResource(allocatable, usage);
    }

    private static class ClusterAutoscalerUnavailableException
    extends Exception {
        public ClusterAutoscalerUnavailableException(String message) {
            super(message);
        }
    }
}

