/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.apache.commons.lang3.builder.Builder;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.reconciler.diff.Diff;
import org.apache.flink.kubernetes.operator.reconciler.diff.DiffResult;

@Experimental
public class DiffBuilder<T>
implements Builder<DiffResult<?>> {
    private static final String DELIMITER = ".";
    private final T before;
    private final T after;
    private final List<Diff<?>> diffs;
    private boolean triviallyEqual;

    public DiffBuilder(@NonNull T before, @NonNull T after) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        this.diffs = new ArrayList();
        this.before = before;
        this.after = after;
        this.triviallyEqual = before == after || before.equals(after);
    }

    public <S> DiffBuilder<T> append(@NonNull String fieldName, S left, S right, BiFunction<S, S, Boolean> equals, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!equals.apply(left, right).booleanValue()) {
            this.diffs.add(new Diff<S>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, Object left, Object right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (left == right) {
            return this;
        }
        Object objectToTest = Objects.requireNonNullElse(left, right);
        if (objectToTest.getClass().isArray()) {
            if (objectToTest instanceof boolean[]) {
                return this.append(fieldName, (boolean[])left, (boolean[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof byte[]) {
                return this.append(fieldName, (byte[])left, (byte[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof char[]) {
                return this.append(fieldName, (char[])left, (char[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof double[]) {
                return this.append(fieldName, (double[])left, (double[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof float[]) {
                return this.append(fieldName, (float[])left, (float[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof int[]) {
                return this.append(fieldName, (int[])left, (int[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof long[]) {
                return this.append(fieldName, (long[])left, (long[])right, Arrays::equals, type);
            }
            if (objectToTest instanceof short[]) {
                return this.append(fieldName, (short[])left, (short[])right, Arrays::equals, type);
            }
            return this.append(fieldName, (Object[])left, (Object[])right, Arrays::equals, type);
        }
        if (left != null && left.equals(right)) {
            return this;
        }
        this.diffs.add(new Diff<Object>(fieldName, left, right, type));
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, Object[] left, Object[] right, DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        if (!Arrays.equals(left, right)) {
            this.diffs.add(new Diff<Object[]>(fieldName, left, right, type));
        }
        return this;
    }

    public DiffBuilder<T> append(@NonNull String fieldName, @NonNull DiffResult<?> diffResult) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (diffResult == null) {
            throw new NullPointerException("diffResult is marked non-null but is null");
        }
        if (this.triviallyEqual) {
            return this;
        }
        diffResult.getDiffList().forEach(diff -> this.append(fieldName + DELIMITER + diff.getFieldName(), diff.getLeft(), diff.getRight(), diff.getType()));
        return this;
    }

    public DiffResult<T> build() {
        return new DiffResult<T>(this.before, this.after, this.diffs);
    }
}

