/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.diff;

import lombok.NonNull;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;

@Experimental
public final class Diff<T> {
    @NonNull
    private final String fieldName;
    private final T left;
    private final T right;
    @NonNull
    private final DiffType type;

    public Diff(@NonNull String fieldName, T left, T right, @NonNull DiffType type) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.fieldName = fieldName;
        this.left = left;
        this.right = right;
        this.type = type;
    }

    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    public T getLeft() {
        return this.left;
    }

    public T getRight() {
        return this.right;
    }

    @NonNull
    public DiffType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Diff)) {
            return false;
        }
        Diff other = (Diff)o;
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        T this$left = this.getLeft();
        T other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        T this$right = this.getRight();
        T other$right = other.getRight();
        if (this$right == null ? other$right != null : !this$right.equals(other$right)) {
            return false;
        }
        DiffType this$type = this.getType();
        DiffType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        T $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        T $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        DiffType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "Diff(fieldName=" + this.getFieldName() + ", left=" + this.getLeft() + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
    }
}

