/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler.deployment;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.autoscaler.JobAutoScaler;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobState;
import org.apache.flink.kubernetes.operator.api.spec.UpgradeMode;
import org.apache.flink.kubernetes.operator.api.status.CheckpointType;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.Savepoint;
import org.apache.flink.kubernetes.operator.api.status.SavepointFormatType;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.exception.UpgradeFailureException;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.reconciler.SnapshotTriggerTimestampStore;
import org.apache.flink.kubernetes.operator.reconciler.SnapshotType;
import org.apache.flink.kubernetes.operator.reconciler.deployment.AbstractFlinkResourceReconciler;
import org.apache.flink.kubernetes.operator.service.CheckpointHistoryWrapper;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.kubernetes.operator.service.SuspendMode;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.FlinkStateSnapshotUtils;
import org.apache.flink.kubernetes.operator.utils.SnapshotUtils;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobReconciler<CR extends AbstractFlinkResource<SPEC, STATUS>, SPEC extends AbstractFlinkSpec, STATUS extends CommonStatus<SPEC>>
extends AbstractFlinkResourceReconciler<CR, SPEC, STATUS> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJobReconciler.class);
    public static final String LAST_STATE_DUMMY_SP_PATH = "KUBERNETES_OPERATOR_LAST_STATE";
    private final SnapshotTriggerTimestampStore snapshotTriggerTimestampStore = new SnapshotTriggerTimestampStore();

    public AbstractJobReconciler(EventRecorder eventRecorder, StatusRecorder<CR, STATUS> statusRecorder, JobAutoScaler<ResourceID, KubernetesJobAutoScalerContext> autoscaler) {
        super(eventRecorder, statusRecorder, autoscaler);
    }

    @Override
    public boolean readyToReconcile(FlinkResourceContext<CR> ctx) {
        CommonStatus status = (CommonStatus)ctx.getResource().getStatus();
        if (status.getReconciliationStatus().isBeforeFirstDeployment()) {
            return true;
        }
        if (this.shouldWaitForPendingSavepoint(status.getJobStatus(), ctx.getObserveConfig())) {
            LOG.info("Delaying job reconciliation until pending savepoint is completed.");
            return false;
        }
        return true;
    }

    private boolean shouldWaitForPendingSavepoint(org.apache.flink.kubernetes.operator.api.status.JobStatus jobStatus, Configuration conf) {
        return !conf.getBoolean(KubernetesOperatorConfigOptions.JOB_UPGRADE_IGNORE_PENDING_SAVEPOINT) && SnapshotUtils.savepointInProgress(jobStatus);
    }

    @Override
    protected boolean reconcileSpecChange(DiffType diffType, FlinkResourceContext<CR> ctx, Configuration deployConfig, SPEC lastReconciledSpec) throws Exception {
        CR resource = ctx.getResource();
        CommonStatus status = (CommonStatus)resource.getStatus();
        AbstractFlinkSpec currentDeploySpec = (AbstractFlinkSpec)resource.getSpec();
        JobState currentJobState = lastReconciledSpec.getJob().getState();
        JobState desiredJobState = currentDeploySpec.getJob().getState();
        if (diffType == DiffType.SAVEPOINT_REDEPLOY) {
            this.redeployWithSavepoint(ctx, deployConfig, resource, status, currentDeploySpec, desiredJobState);
            return true;
        }
        if (currentJobState == JobState.RUNNING) {
            boolean async;
            JobUpgrade jobUpgrade = this.getJobUpgrade(ctx, deployConfig);
            if (!jobUpgrade.isAvailable()) {
                LOG.info("Job is not running and checkpoint information is not available for executing the upgrade, waiting for upgradeable state");
                return !jobUpgrade.allowOtherReconcileActions;
            }
            LOG.debug("Job upgrade available: {}", (Object)jobUpgrade);
            SuspendMode suspendMode = jobUpgrade.getSuspendMode();
            if (suspendMode != SuspendMode.NOOP) {
                this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)resource, EventRecorder.Type.Normal, EventRecorder.Reason.Suspended, EventRecorder.Component.JobManagerDeployment, "Suspending existing deployment.", ctx.getKubernetesClient());
            }
            if (async = this.cancelJob(ctx, suspendMode)) {
                ((CommonStatus)resource.getStatus()).getReconciliationStatus().setState(ReconciliationState.UPGRADING);
                ReconciliationUtils.updateLastReconciledSpec(resource, (s, m) -> {
                    s.getJob().setUpgradeMode(jobUpgrade.getRestoreMode());
                    m.setFirstDeployment(false);
                });
                return true;
            }
            currentDeploySpec.getJob().setUpgradeMode(jobUpgrade.getRestoreMode());
            if (desiredJobState == JobState.RUNNING) {
                ReconciliationUtils.updateStatusBeforeDeploymentAttempt(resource, deployConfig, this.clock);
            } else {
                ReconciliationUtils.updateStatusForDeployedSpec(resource, deployConfig, this.clock);
            }
            if (suspendMode == SuspendMode.NOOP) {
                lastReconciledSpec.getJob().setUpgradeMode(jobUpgrade.getRestoreMode());
                currentJobState = JobState.SUSPENDED;
            }
        }
        if (currentJobState == JobState.SUSPENDED && desiredJobState == JobState.RUNNING) {
            if (currentDeploySpec.getJob().getUpgradeMode() != UpgradeMode.STATELESS) {
                currentDeploySpec.getJob().setUpgradeMode(lastReconciledSpec.getJob().getUpgradeMode());
            }
            ReconciliationUtils.updateStatusBeforeDeploymentAttempt(resource, deployConfig, this.clock);
            this.statusRecorder.patchAndCacheStatus(resource, ctx.getKubernetesClient());
            this.restoreJob(ctx, currentDeploySpec, deployConfig, lastReconciledSpec.getJob().getUpgradeMode() == UpgradeMode.LAST_STATE);
            ReconciliationUtils.updateStatusForDeployedSpec(resource, deployConfig, this.clock);
        }
        return true;
    }

    protected JobUpgrade getJobUpgrade(FlinkResourceContext<CR> ctx, Configuration deployConfig) throws Exception {
        CR resource = ctx.getResource();
        CommonStatus status = (CommonStatus)resource.getStatus();
        UpgradeMode upgradeMode = ((AbstractFlinkSpec)resource.getSpec()).getJob().getUpgradeMode();
        boolean terminal = ReconciliationUtils.isJobInTerminalState(status);
        if (upgradeMode == UpgradeMode.STATELESS) {
            LOG.info("Stateless job, ready for upgrade");
            return JobUpgrade.stateless(terminal);
        }
        FlinkService flinkService = ctx.getFlinkService();
        if (ReconciliationUtils.isJobCancelled(status) || terminal && !flinkService.isHaMetadataAvailable(ctx.getObserveConfig())) {
            if (!SnapshotUtils.lastSavepointKnown(status)) {
                throw new UpgradeFailureException("Job is in terminal state but last checkpoint is unknown, possibly due to an unrecoverable restore error. Manual restore required.", "UpgradeFailed");
            }
            LOG.info("Job is in terminal state, ready for upgrade from observed latest state");
            return JobUpgrade.savepoint(true);
        }
        if (ReconciliationUtils.isJobCancelling(status)) {
            LOG.info("Cancellation is in progress. Waiting for cancelled state.");
            return JobUpgrade.pendingCancellation();
        }
        boolean running = ReconciliationUtils.isJobRunning(status);
        boolean versionChanged = this.flinkVersionChanged(ReconciliationUtils.getDeployedSpec(resource), (AbstractFlinkSpec)resource.getSpec());
        if (upgradeMode == UpgradeMode.SAVEPOINT) {
            if (running) {
                LOG.info("Job is in running state, ready for upgrade with savepoint");
                return JobUpgrade.savepoint(false);
            }
            if (versionChanged || ((Boolean)deployConfig.get(KubernetesOperatorConfigOptions.OPERATOR_JOB_UPGRADE_LAST_STATE_FALLBACK_ENABLED)).booleanValue()) {
                LOG.info("Falling back to last-state upgrade mode from savepoint");
                upgradeMode = UpgradeMode.LAST_STATE;
                ((AbstractFlinkSpec)ctx.getResource().getSpec()).getJob().setUpgradeMode(upgradeMode);
            } else {
                LOG.info("Last-state fallback is disabled, waiting for upgradable state");
                return JobUpgrade.pendingUpgrade();
            }
        }
        if (upgradeMode == UpgradeMode.LAST_STATE) {
            if (versionChanged) {
                boolean savepointPossible;
                boolean bl = savepointPossible = !StringUtils.isNullOrWhitespaceOnly((String)ctx.getObserveConfig().getString(CheckpointingOptions.SAVEPOINT_DIRECTORY));
                if (running && savepointPossible) {
                    LOG.info("Using savepoint to upgrade Flink version");
                    return JobUpgrade.savepoint(false);
                }
                if (ReconciliationUtils.isJobCancellable((CommonStatus)resource.getStatus())) {
                    LOG.info("Using last-state upgrade with cancellation to upgrade Flink version");
                    return JobUpgrade.lastStateUsingCancel();
                }
                LOG.info("Neither savepoint nor cancellation is possible, cannot perform stateful version upgrade");
                return JobUpgrade.pendingUpgrade();
            }
            boolean cancellable = this.allowLastStateCancel(ctx);
            if (running) {
                JobUpgrade mode = this.getUpgradeModeBasedOnStateAge(ctx, deployConfig, cancellable);
                LOG.info("Job is running, using {} for last-state upgrade", (Object)mode);
                return mode;
            }
            if (cancellable) {
                LOG.info("Job is not running, using cancel to perform last-state upgrade");
                return JobUpgrade.lastStateUsingCancel();
            }
        }
        return JobUpgrade.unavailable();
    }

    @VisibleForTesting
    protected JobUpgrade getUpgradeModeBasedOnStateAge(FlinkResourceContext<CR> ctx, Configuration deployConfig, boolean cancellable) throws Exception {
        JobUpgrade defaultMode = cancellable ? JobUpgrade.lastStateUsingCancel() : JobUpgrade.lastStateUsingHaMeta();
        Duration maxAge = (Duration)deployConfig.get(KubernetesOperatorConfigOptions.OPERATOR_JOB_UPGRADE_LAST_STATE_CHECKPOINT_MAX_AGE);
        if (maxAge == null) {
            return defaultMode;
        }
        org.apache.flink.kubernetes.operator.api.status.JobStatus jobStatus = ((CommonStatus)ctx.getResource().getStatus()).getJobStatus();
        JobID jobId = JobID.fromHexString((String)jobStatus.getJobId());
        Instant startTime = Instant.ofEpochMilli(Long.parseLong(jobStatus.getStartTime()));
        Instant now = this.clock.instant();
        Predicate<Instant> withinMaxAge = ts -> now.minus(maxAge).isBefore((Instant)ts);
        if (withinMaxAge.test(startTime)) {
            return defaultMode;
        }
        Tuple2<Optional<CheckpointHistoryWrapper.CompletedCheckpointInfo>, Optional<CheckpointHistoryWrapper.PendingCheckpointInfo>> chkInfo = ctx.getFlinkService().getCheckpointInfo(jobId, ctx.getObserveConfig());
        Instant completedTs = ((Optional)chkInfo.f0).map(CheckpointHistoryWrapper.CompletedCheckpointInfo::getTimestamp).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        Instant pendingTs = ((Optional)chkInfo.f1).map(CheckpointHistoryWrapper.PendingCheckpointInfo::getTimestamp).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        if (withinMaxAge.test(completedTs)) {
            return defaultMode;
        }
        if (withinMaxAge.test(pendingTs)) {
            LOG.info("Waiting for pending checkpoint to complete before upgrading.");
            return JobUpgrade.pendingUpgrade();
        }
        LOG.info("Using savepoint upgrade mode because latest checkpoint is too old for last-state upgrade");
        return JobUpgrade.savepoint(false);
    }

    private boolean allowLastStateCancel(FlinkResourceContext<CR> ctx) {
        CR resource = ctx.getResource();
        if (!ReconciliationUtils.isJobCancellable((CommonStatus)resource.getStatus())) {
            return false;
        }
        if (resource instanceof FlinkSessionJob) {
            return true;
        }
        Configuration conf = ctx.getObserveConfig();
        if (!ctx.getFlinkService().isHaMetadataAvailable(conf)) {
            LOG.info("HA metadata not available, cancel will be used instead of last-state");
            return true;
        }
        return (Boolean)conf.get(KubernetesOperatorConfigOptions.OPERATOR_JOB_UPGRADE_LAST_STATE_CANCEL_JOB);
    }

    protected void restoreJob(FlinkResourceContext<CR> ctx, SPEC spec, Configuration deployConfig, boolean requireHaMetadata) throws Exception {
        Optional<String> savepointOpt = Optional.empty();
        if (spec.getJob().getUpgradeMode() == UpgradeMode.SAVEPOINT && (savepointOpt = Optional.ofNullable(((CommonStatus)ctx.getResource().getStatus()).getJobStatus().getUpgradeSavepointPath())).isEmpty()) {
            savepointOpt = Optional.ofNullable(((CommonStatus)ctx.getResource().getStatus()).getJobStatus().getSavepointInfo().getLastSavepoint()).flatMap(s -> Optional.ofNullable(s.getLocation()));
        }
        this.deploy(ctx, spec, deployConfig, savepointOpt, requireHaMetadata);
    }

    protected void setUpgradeSavepointPath(FlinkResourceContext<?> ctx, String savepointLocation) {
        Configuration conf = ctx.getObserveConfig();
        org.apache.flink.core.execution.SavepointFormatType savepointFormatType = (org.apache.flink.core.execution.SavepointFormatType)ctx.getObserveConfig().get(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_FORMAT_TYPE);
        FlinkStateSnapshotUtils.createUpgradeSnapshotResource(conf, ctx.getOperatorConfig(), ctx.getKubernetesClient(), ctx.getResource(), SavepointFormatType.valueOf((String)savepointFormatType.name()), savepointLocation);
        ((CommonStatus)ctx.getResource().getStatus()).getJobStatus().setUpgradeSavepointPath(savepointLocation);
    }

    @Override
    public boolean reconcileOtherChanges(FlinkResourceContext<CR> ctx) throws Exception {
        CommonStatus status = (CommonStatus)ctx.getResource().getStatus();
        JobStatus jobStatus = status.getJobStatus().getState();
        if (jobStatus == JobStatus.FAILED && ctx.getObserveConfig().getBoolean(KubernetesOperatorConfigOptions.OPERATOR_JOB_RESTART_FAILED)) {
            LOG.info("Stopping failed Flink job...");
            this.cleanupAfterFailedJob(ctx);
            status.setError(null);
            this.resubmitJob(ctx, false);
            return true;
        }
        boolean savepointTriggered = this.triggerSnapshotIfNeeded(ctx, SnapshotType.SAVEPOINT);
        boolean checkpointTriggered = this.triggerSnapshotIfNeeded(ctx, SnapshotType.CHECKPOINT);
        return savepointTriggered || checkpointTriggered;
    }

    private boolean triggerSnapshotIfNeeded(FlinkResourceContext<CR> ctx, SnapshotType snapshotType) throws Exception {
        Instant lastTrigger;
        Configuration conf;
        CR resource = ctx.getResource();
        Optional<SnapshotTriggerType> triggerOpt = SnapshotUtils.shouldTriggerSnapshot(resource, conf = ctx.getObserveConfig(), snapshotType, lastTrigger = this.snapshotTriggerTimestampStore.getLastPeriodicTriggerInstant((AbstractFlinkResource<?, ?>)resource, snapshotType, FlinkStateSnapshotUtils.getFlinkStateSnapshotsSupplier(ctx)));
        if (triggerOpt.isEmpty()) {
            return false;
        }
        SnapshotTriggerType triggerType = triggerOpt.get();
        if (SnapshotTriggerType.PERIODIC.equals((Object)triggerType)) {
            this.snapshotTriggerTimestampStore.updateLastPeriodicTriggerTimestamp((HasMetadata)resource, snapshotType, Instant.now());
        }
        boolean createSnapshotResource = FlinkStateSnapshotUtils.isSnapshotResourceEnabled(ctx.getOperatorConfig(), conf);
        String jobId = ((CommonStatus)resource.getStatus()).getJobStatus().getJobId();
        switch (snapshotType) {
            case SAVEPOINT: {
                org.apache.flink.core.execution.SavepointFormatType savepointFormatType = (org.apache.flink.core.execution.SavepointFormatType)conf.get(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_FORMAT_TYPE);
                String savepointDirectory = (String)Preconditions.checkNotNull((Object)((String)conf.get(CheckpointingOptions.SAVEPOINT_DIRECTORY)));
                if (createSnapshotResource) {
                    FlinkStateSnapshotUtils.createSavepointResource(ctx.getKubernetesClient(), resource, savepointDirectory, triggerType, SavepointFormatType.valueOf((String)savepointFormatType.name()), conf.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_JOB_SAVEPOINT_DISPOSE_ON_DELETE));
                    ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce(triggerType, resource, SnapshotType.SAVEPOINT);
                    break;
                }
                String triggerId = ctx.getFlinkService().triggerSavepoint(jobId, savepointFormatType, savepointDirectory, conf);
                ((CommonStatus)resource.getStatus()).getJobStatus().getSavepointInfo().setTrigger(triggerId, triggerType, SavepointFormatType.valueOf((String)savepointFormatType.name()));
                break;
            }
            case CHECKPOINT: {
                if (createSnapshotResource) {
                    FlinkStateSnapshotUtils.createCheckpointResource(ctx.getKubernetesClient(), resource, triggerType);
                    ReconciliationUtils.updateLastReconciledSnapshotTriggerNonce(triggerType, resource, SnapshotType.CHECKPOINT);
                    break;
                }
                CheckpointType checkpointType = (CheckpointType)conf.get(KubernetesOperatorConfigOptions.OPERATOR_CHECKPOINT_TYPE);
                String triggerId = ctx.getFlinkService().triggerCheckpoint(jobId, org.apache.flink.core.execution.CheckpointType.valueOf((String)checkpointType.name()), conf);
                ((CommonStatus)resource.getStatus()).getJobStatus().getCheckpointInfo().setTrigger(triggerId, triggerType, checkpointType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported snapshot type: " + snapshotType);
            }
        }
        return true;
    }

    protected void resubmitJob(FlinkResourceContext<CR> ctx, boolean requireHaMetadata) throws Exception {
        boolean lastSavepointKnown;
        LOG.info("Resubmitting Flink job...");
        Object specToRecover = ReconciliationUtils.getDeployedSpec(ctx.getResource());
        String upgradeStatePath = ((CommonStatus)ctx.getResource().getStatus()).getJobStatus().getUpgradeSavepointPath();
        Savepoint savepointLegacy = ((CommonStatus)ctx.getResource().getStatus()).getJobStatus().getSavepointInfo().getLastSavepoint();
        boolean bl = lastSavepointKnown = upgradeStatePath != null || savepointLegacy != null;
        if (requireHaMetadata) {
            specToRecover.getJob().setUpgradeMode(UpgradeMode.LAST_STATE);
        } else if (((AbstractFlinkSpec)ctx.getResource().getSpec()).getJob().getUpgradeMode() != UpgradeMode.STATELESS && lastSavepointKnown) {
            specToRecover.getJob().setUpgradeMode(UpgradeMode.SAVEPOINT);
        }
        this.restoreJob(ctx, specToRecover, ctx.getObserveConfig(), requireHaMetadata);
    }

    private void redeployWithSavepoint(FlinkResourceContext<CR> ctx, Configuration deployConfig, CR resource, STATUS status, SPEC currentDeploySpec, JobState desiredJobState) throws Exception {
        LOG.info("Redeploying from savepoint");
        this.cancelJob(ctx, SuspendMode.STATELESS);
        currentDeploySpec.getJob().setUpgradeMode(UpgradeMode.SAVEPOINT);
        Optional<String> savepointPath = Optional.ofNullable(currentDeploySpec.getJob().getInitialSavepointPath());
        status.getJobStatus().setUpgradeSavepointPath((String)savepointPath.orElse(null));
        if (desiredJobState == JobState.RUNNING) {
            this.deploy(ctx, currentDeploySpec, ctx.getDeployConfig((AbstractFlinkSpec)currentDeploySpec), savepointPath, false);
        }
        ReconciliationUtils.updateStatusForDeployedSpec(resource, deployConfig, this.clock);
        status.getReconciliationStatus().markReconciledSpecAsStable();
    }

    protected abstract boolean cancelJob(FlinkResourceContext<CR> var1, SuspendMode var2) throws Exception;

    protected abstract void cleanupAfterFailedJob(FlinkResourceContext<CR> var1) throws Exception;

    public static final class JobUpgrade {
        private final SuspendMode suspendMode;
        private final UpgradeMode restoreMode;
        private final boolean available;
        private final boolean allowFallback;
        private final boolean allowOtherReconcileActions;

        static JobUpgrade stateless(boolean terminal) {
            return new JobUpgrade(terminal ? SuspendMode.NOOP : SuspendMode.STATELESS, UpgradeMode.STATELESS, true, false, false);
        }

        static JobUpgrade savepoint(boolean terminal) {
            return new JobUpgrade(terminal ? SuspendMode.NOOP : SuspendMode.SAVEPOINT, UpgradeMode.SAVEPOINT, true, false, false);
        }

        static JobUpgrade lastStateUsingHaMeta() {
            return new JobUpgrade(SuspendMode.LAST_STATE, UpgradeMode.LAST_STATE, true, false, false);
        }

        static JobUpgrade lastStateUsingCancel() {
            return new JobUpgrade(SuspendMode.CANCEL, UpgradeMode.SAVEPOINT, true, false, false);
        }

        static JobUpgrade pendingCancellation() {
            return new JobUpgrade(null, null, false, false, false);
        }

        static JobUpgrade pendingUpgrade() {
            return new JobUpgrade(null, null, false, false, true);
        }

        static JobUpgrade unavailable() {
            return new JobUpgrade(null, null, false, true, true);
        }

        public JobUpgrade(SuspendMode suspendMode, UpgradeMode restoreMode, boolean available, boolean allowFallback, boolean allowOtherReconcileActions) {
            this.suspendMode = suspendMode;
            this.restoreMode = restoreMode;
            this.available = available;
            this.allowFallback = allowFallback;
            this.allowOtherReconcileActions = allowOtherReconcileActions;
        }

        public SuspendMode getSuspendMode() {
            return this.suspendMode;
        }

        public UpgradeMode getRestoreMode() {
            return this.restoreMode;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean isAllowFallback() {
            return this.allowFallback;
        }

        public boolean isAllowOtherReconcileActions() {
            return this.allowOtherReconcileActions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobUpgrade)) {
                return false;
            }
            JobUpgrade other = (JobUpgrade)o;
            if (this.isAvailable() != other.isAvailable()) {
                return false;
            }
            if (this.isAllowFallback() != other.isAllowFallback()) {
                return false;
            }
            if (this.isAllowOtherReconcileActions() != other.isAllowOtherReconcileActions()) {
                return false;
            }
            SuspendMode this$suspendMode = this.getSuspendMode();
            SuspendMode other$suspendMode = other.getSuspendMode();
            if (this$suspendMode == null ? other$suspendMode != null : !((Object)((Object)this$suspendMode)).equals((Object)other$suspendMode)) {
                return false;
            }
            UpgradeMode this$restoreMode = this.getRestoreMode();
            UpgradeMode other$restoreMode = other.getRestoreMode();
            return !(this$restoreMode == null ? other$restoreMode != null : !this$restoreMode.equals(other$restoreMode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAvailable() ? 79 : 97);
            result = result * 59 + (this.isAllowFallback() ? 79 : 97);
            result = result * 59 + (this.isAllowOtherReconcileActions() ? 79 : 97);
            SuspendMode $suspendMode = this.getSuspendMode();
            result = result * 59 + ($suspendMode == null ? 43 : ((Object)((Object)$suspendMode)).hashCode());
            UpgradeMode $restoreMode = this.getRestoreMode();
            result = result * 59 + ($restoreMode == null ? 43 : $restoreMode.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractJobReconciler.JobUpgrade(suspendMode=" + this.getSuspendMode() + ", restoreMode=" + this.getRestoreMode() + ", available=" + this.isAvailable() + ", allowFallback=" + this.isAllowFallback() + ", allowOtherReconcileActions=" + this.isAllowOtherReconcileActions() + ")";
        }
    }
}

