/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.time.Instant;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.flink.autoscaler.utils.DateTimeUtils;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkStateSnapshotSpec;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.apache.flink.kubernetes.operator.api.status.SavepointInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;
import org.apache.flink.kubernetes.operator.reconciler.SnapshotType;

public class SnapshotTriggerTimestampStore {
    private final ConcurrentHashMap<String, Instant> checkpointsLastTriggeredCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Instant> savepointsLastTriggeredCache = new ConcurrentHashMap();

    public Instant getLastPeriodicTriggerInstant(AbstractFlinkResource<?, ?> resource, SnapshotType snapshotType, Supplier<Set<FlinkStateSnapshot>> snapshotsSupplier) {
        Instant creationInstant;
        Map<String, Instant> cache = this.getCacheForSnapshotType(snapshotType);
        if (cache.containsKey(resource.getMetadata().getUid())) {
            return cache.get(resource.getMetadata().getUid());
        }
        Optional<Instant> instantOpt = snapshotsSupplier.get().stream().filter(s -> s.getStatus() != null && FlinkStateSnapshotStatus.State.COMPLETED.equals((Object)((FlinkStateSnapshotStatus)s.getStatus()).getState())).filter(s -> snapshotType == SnapshotType.SAVEPOINT == ((FlinkStateSnapshotSpec)s.getSpec()).isSavepoint()).filter(s -> SnapshotTriggerType.PERIODIC.name().equals(s.getMetadata().getLabels().get("snapshot.trigger-type"))).map(s -> DateTimeUtils.parseKubernetes((String)s.getMetadata().getCreationTimestamp())).max(Comparator.naturalOrder());
        if (instantOpt.isPresent()) {
            return instantOpt.get();
        }
        Instant legacyInstant = this.getLegacyTimestamp(resource, snapshotType);
        Instant maxInstant = legacyInstant.compareTo(creationInstant = Instant.parse(resource.getMetadata().getCreationTimestamp())) > 0 ? legacyInstant : creationInstant;
        this.updateLastPeriodicTriggerTimestamp((HasMetadata)resource, snapshotType, maxInstant);
        return maxInstant;
    }

    public void updateLastPeriodicTriggerTimestamp(HasMetadata resource, SnapshotType snapshotType, Instant instant) {
        this.getCacheForSnapshotType(snapshotType).put(resource.getMetadata().getUid(), instant);
    }

    private Map<String, Instant> getCacheForSnapshotType(SnapshotType snapshotType) {
        switch (snapshotType) {
            case SAVEPOINT: {
                return this.savepointsLastTriggeredCache;
            }
            case CHECKPOINT: {
                return this.checkpointsLastTriggeredCache;
            }
        }
        throw new IllegalArgumentException("Unsupported snapshot type: " + snapshotType);
    }

    private Instant getLegacyTimestamp(AbstractFlinkResource<?, ?> resource, SnapshotType snapshotType) {
        SavepointInfo snapshotInfo;
        switch (snapshotType) {
            case SAVEPOINT: {
                snapshotInfo = ((CommonStatus)resource.getStatus()).getJobStatus().getSavepointInfo();
                break;
            }
            case CHECKPOINT: {
                snapshotInfo = ((CommonStatus)resource.getStatus()).getJobStatus().getCheckpointInfo();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported snapshot type: " + snapshotType);
            }
        }
        return Instant.ofEpochMilli(snapshotInfo.getLastPeriodicTriggerTimestamp());
    }
}

