/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import java.util.concurrent.TimeoutException;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentReconciliationStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.observer.deployment.AbstractFlinkDeploymentObserver;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;

public class SessionObserver
extends AbstractFlinkDeploymentObserver {
    public SessionObserver(EventRecorder eventRecorder) {
        super(eventRecorder);
    }

    @Override
    public void observeFlinkCluster(FlinkResourceContext<FlinkDeployment> ctx) {
        block3: {
            try {
                this.logger.debug("Observing session cluster");
                ctx.getFlinkService().getClusterInfo(ctx.getObserveConfig(), null);
                FlinkDeploymentReconciliationStatus rs = ((FlinkDeploymentStatus)ctx.getResource().getStatus()).getReconciliationStatus();
                if (rs.getState() == ReconciliationState.DEPLOYED) {
                    rs.markReconciledSpecAsStable();
                }
            }
            catch (Exception e) {
                this.logger.error("REST service in session cluster timed out", (Throwable)e);
                if (!(e instanceof TimeoutException)) break block3;
                this.observeJmDeployment(ctx);
            }
        }
    }
}

