/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.observer.deployment;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.observer.ClusterHealthObserver;
import org.apache.flink.kubernetes.operator.observer.JobStatusObserver;
import org.apache.flink.kubernetes.operator.observer.SnapshotObserver;
import org.apache.flink.kubernetes.operator.observer.deployment.AbstractFlinkDeploymentObserver;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;

public class ApplicationObserver
extends AbstractFlinkDeploymentObserver {
    private final SnapshotObserver<FlinkDeployment, FlinkDeploymentStatus> savepointObserver;
    private final JobStatusObserver<FlinkDeployment> jobStatusObserver;
    private final ClusterHealthObserver clusterHealthObserver;

    public ApplicationObserver(EventRecorder eventRecorder) {
        super(eventRecorder);
        this.savepointObserver = new SnapshotObserver(eventRecorder);
        this.jobStatusObserver = new ApplicationJobObserver(eventRecorder);
        this.clusterHealthObserver = new ClusterHealthObserver();
    }

    @Override
    protected void observeFlinkCluster(FlinkResourceContext<FlinkDeployment> ctx) {
        this.logger.debug("Observing application cluster");
        boolean jobFound = this.jobStatusObserver.observe(ctx);
        if (jobFound) {
            Configuration observeConfig = ctx.getObserveConfig();
            this.savepointObserver.observeSavepointStatus(ctx);
            this.savepointObserver.observeCheckpointStatus(ctx);
            if (observeConfig.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_CLUSTER_HEALTH_CHECK_ENABLED)) {
                this.clusterHealthObserver.observe(ctx);
            }
        }
    }

    private class ApplicationJobObserver
    extends JobStatusObserver<FlinkDeployment> {
        public ApplicationJobObserver(EventRecorder eventRecorder) {
            super(eventRecorder);
        }

        @Override
        public void onTimeout(FlinkResourceContext<FlinkDeployment> ctx) {
            ApplicationObserver.this.observeJmDeployment(ctx);
        }
    }
}

