/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.mutator;

import java.util.HashMap;
import java.util.Optional;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.mutator.FlinkResourceMutator;

public class DefaultFlinkMutator
implements FlinkResourceMutator {
    @Override
    public FlinkDeployment mutateDeployment(FlinkDeployment deployment) {
        return deployment;
    }

    @Override
    public FlinkSessionJob mutateSessionJob(FlinkSessionJob sessionJob, Optional<FlinkDeployment> session) {
        this.setSessionTargetLabel(sessionJob);
        return sessionJob;
    }

    @Override
    public FlinkStateSnapshot mutateStateSnapshot(FlinkStateSnapshot stateSnapshot) {
        return stateSnapshot;
    }

    private void setSessionTargetLabel(FlinkSessionJob flinkSessionJob) {
        String deploymentName;
        HashMap<String, String> labels = flinkSessionJob.getMetadata().getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>();
        }
        if ((deploymentName = ((FlinkSessionJobSpec)flinkSessionJob.getSpec()).getDeploymentName()) != null && !deploymentName.equals(labels.get("target.session"))) {
            labels.put("target.session", ((FlinkSessionJobSpec)flinkSessionJob.getSpec()).getDeploymentName());
            flinkSessionJob.getMetadata().setLabels(labels);
        }
    }
}

