/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics.lifecycle;

import io.fabric8.kubernetes.client.CustomResource;
import java.time.Clock;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.metrics.OperatorMetricUtils;
import org.apache.flink.kubernetes.operator.metrics.lifecycle.ResourceLifecycleMetricTracker;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;

public class LifecycleMetrics<CR extends AbstractFlinkResource<?, ?>>
implements CustomResourceMetrics<CR> {
    private static final String TRANSITION_RESUME = "Resume";
    private static final String TRANSITION_UPGRADE = "Upgrade";
    private static final String TRANSITION_SUSPEND = "Suspend";
    private static final String TRANSITION_SUBMISSION = "Submission";
    private static final String TRANSITION_STABILIZATION = "Stabilization";
    private static final String TRANSITION_ROLLBACK = "Rollback";
    public static final List<Transition> TRACKED_TRANSITIONS = LifecycleMetrics.getTrackedTransitions();
    private final Map<Tuple2<String, String>, ResourceLifecycleMetricTracker> lifecycleTrackers = new ConcurrentHashMap<Tuple2<String, String>, ResourceLifecycleMetricTracker>();
    private final Set<String> namespaces = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Clock clock;
    private final KubernetesOperatorMetricGroup operatorMetricGroup;
    private final boolean namespaceHistosEnabled;
    private Map<String, Tuple2<Histogram, Map<String, Histogram>>> transitionMetrics;
    private Map<ResourceLifecycleState, Tuple2<Histogram, Map<String, Histogram>>> stateTimeMetrics;
    private Function<MetricGroup, MetricGroup> metricGroupFunction = mg -> mg.addGroup("Lifecycle");
    private FlinkOperatorConfiguration operatorConfig;
    private Configuration config;

    public LifecycleMetrics(Configuration configuration, KubernetesOperatorMetricGroup operatorMetricGroup) {
        this.clock = Clock.systemDefaultZone();
        this.operatorMetricGroup = operatorMetricGroup;
        this.config = configuration;
        this.operatorConfig = FlinkOperatorConfiguration.fromConfiguration(this.config);
        this.namespaceHistosEnabled = (Boolean)this.config.get(KubernetesOperatorMetricOptions.OPERATOR_LIFECYCLE_NAMESPACE_HISTOGRAMS_ENABLED);
    }

    @Override
    public void onUpdate(CR cr) {
        CommonStatus status = (CommonStatus)cr.getStatus();
        this.getLifecycleMetricTracker(cr).onUpdate(status.getLifecycleState(), this.clock.instant());
    }

    @Override
    public void onRemove(CR cr) {
        this.lifecycleTrackers.remove(Tuple2.of((Object)cr.getMetadata().getNamespace(), (Object)cr.getMetadata().getName()));
    }

    private ResourceLifecycleMetricTracker getLifecycleMetricTracker(CR cr) {
        this.init(cr);
        this.createNamespaceStateCountIfMissing(cr);
        return this.lifecycleTrackers.computeIfAbsent((Tuple2<String, String>)Tuple2.of((Object)cr.getMetadata().getNamespace(), (Object)cr.getMetadata().getName()), k -> {
            ResourceLifecycleState initialState = ((CommonStatus)cr.getStatus()).getLifecycleState();
            Instant time = initialState == ResourceLifecycleState.CREATED ? Instant.parse(cr.getMetadata().getCreationTimestamp()) : this.clock.instant();
            return new ResourceLifecycleMetricTracker(initialState, time, this.getTransitionHistograms(cr), this.getStateTimeHistograms(cr));
        });
    }

    private void createNamespaceStateCountIfMissing(CR cr) {
        String namespace = cr.getMetadata().getNamespace();
        if (!this.namespaces.add(namespace)) {
            return;
        }
        MetricGroup lifecycleGroup = this.metricGroupFunction.apply((MetricGroup)this.operatorMetricGroup.createResourceNamespaceGroup(this.config, cr.getClass(), namespace));
        for (ResourceLifecycleState state : ResourceLifecycleState.values()) {
            lifecycleGroup.addGroup("State").addGroup(state.name()).gauge("Count", () -> this.lifecycleTrackers.entrySet().stream().filter(tracker -> ((String)((Tuple2)tracker.getKey()).f0).equals(namespace) && ((ResourceLifecycleMetricTracker)tracker.getValue()).getCurrentState() == state).count());
        }
    }

    private synchronized void init(CR cr) {
        if (this.transitionMetrics != null) {
            return;
        }
        this.transitionMetrics = new ConcurrentHashMap<String, Tuple2<Histogram, Map<String, Histogram>>>();
        TRACKED_TRANSITIONS.forEach(t -> this.transitionMetrics.computeIfAbsent(t.metricName, name -> Tuple2.of((Object)this.createTransitionHistogram((String)name, this.operatorMetricGroup.addGroup(cr.getClass().getSimpleName())), new ConcurrentHashMap())));
        this.stateTimeMetrics = new ConcurrentHashMap<ResourceLifecycleState, Tuple2<Histogram, Map<String, Histogram>>>();
        for (ResourceLifecycleState state : ResourceLifecycleState.values()) {
            this.stateTimeMetrics.put(state, (Tuple2<Histogram, Map<String, Histogram>>)Tuple2.of((Object)this.createStateTimeHistogram(state, this.operatorMetricGroup.addGroup(cr.getClass().getSimpleName())), new ConcurrentHashMap()));
        }
    }

    private Map<String, List<Histogram>> getTransitionHistograms(CR cr) {
        HashMap<String, List<Histogram>> histos = new HashMap<String, List<Histogram>>();
        this.transitionMetrics.forEach((metricName, t) -> histos.put((String)metricName, this.namespaceHistosEnabled ? List.of((Histogram)t.f0, ((Map)t.f1).computeIfAbsent(cr.getMetadata().getNamespace(), ns -> this.createTransitionHistogram((String)metricName, (MetricGroup)this.operatorMetricGroup.createResourceNamespaceGroup(this.config, (Class<? extends CustomResource>)cr.getClass(), (String)ns)))) : List.of((Histogram)t.f0)));
        return histos;
    }

    private Map<ResourceLifecycleState, List<Histogram>> getStateTimeHistograms(CR cr) {
        HashMap<ResourceLifecycleState, List<Histogram>> histos = new HashMap<ResourceLifecycleState, List<Histogram>>();
        this.stateTimeMetrics.forEach((state, t) -> histos.put((ResourceLifecycleState)state, this.namespaceHistosEnabled ? List.of((Histogram)t.f0, ((Map)t.f1).computeIfAbsent(cr.getMetadata().getNamespace(), ns -> this.createStateTimeHistogram((ResourceLifecycleState)state, (MetricGroup)this.operatorMetricGroup.createResourceNamespaceGroup(this.config, (Class<? extends CustomResource>)cr.getClass(), (String)ns)))) : List.of((Histogram)t.f0)));
        return histos;
    }

    private Histogram createTransitionHistogram(String metricName, MetricGroup group) {
        return this.metricGroupFunction.apply(group).addGroup("Transition").addGroup(metricName).histogram("TimeSeconds", OperatorMetricUtils.createHistogram(this.operatorConfig));
    }

    private Histogram createStateTimeHistogram(ResourceLifecycleState state, MetricGroup group) {
        return this.metricGroupFunction.apply(group).addGroup("State").addGroup(state.name()).histogram("TimeSeconds", OperatorMetricUtils.createHistogram(this.operatorConfig));
    }

    private static List<Transition> getTrackedTransitions() {
        return List.of(new Transition(ResourceLifecycleState.SUSPENDED, ResourceLifecycleState.STABLE, true, TRANSITION_RESUME), new Transition(ResourceLifecycleState.STABLE, ResourceLifecycleState.STABLE, true, TRANSITION_UPGRADE), new Transition(ResourceLifecycleState.DEPLOYED, ResourceLifecycleState.UPGRADING, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.STABLE, ResourceLifecycleState.UPGRADING, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.ROLLED_BACK, ResourceLifecycleState.UPGRADING, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.DEPLOYED, ResourceLifecycleState.SUSPENDED, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.STABLE, ResourceLifecycleState.SUSPENDED, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.ROLLED_BACK, ResourceLifecycleState.SUSPENDED, true, TRANSITION_SUSPEND), new Transition(ResourceLifecycleState.DEPLOYED, ResourceLifecycleState.STABLE, false, TRANSITION_STABILIZATION), new Transition(ResourceLifecycleState.DEPLOYED, ResourceLifecycleState.ROLLED_BACK, false, TRANSITION_ROLLBACK), new Transition(ResourceLifecycleState.UPGRADING, ResourceLifecycleState.DEPLOYED, true, TRANSITION_SUBMISSION), new Transition(ResourceLifecycleState.ROLLING_BACK, ResourceLifecycleState.ROLLED_BACK, true, TRANSITION_SUBMISSION));
    }

    @VisibleForTesting
    protected Map<Tuple2<String, String>, ResourceLifecycleMetricTracker> getLifecycleTrackers() {
        return this.lifecycleTrackers;
    }

    protected static class Transition {
        public final ResourceLifecycleState from;
        public final ResourceLifecycleState to;
        public final boolean measureFromLastUpdate;
        public final String metricName;

        public String toString() {
            return "LifecycleMetrics.Transition(from=" + this.from + ", to=" + this.to + ", measureFromLastUpdate=" + this.measureFromLastUpdate + ", metricName=" + this.metricName + ")";
        }

        public Transition(ResourceLifecycleState from, ResourceLifecycleState to, boolean measureFromLastUpdate, String metricName) {
            this.from = from;
            this.to = to;
            this.measureFromLastUpdate = measureFromLastUpdate;
            this.metricName = metricName;
        }
    }
}

