/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.GroupVersionKind;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceAction;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.OperatorMetricUtils;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class OperatorJosdkMetrics
implements Metrics {
    private static final String OPERATOR_SDK_GROUP = "JOSDK";
    private static final String RECONCILIATION = "Reconciliation";
    private static final String RESOURCE = "Resource";
    private static final String EVENT = "Event";
    private final KubernetesOperatorMetricGroup operatorMetricGroup;
    private final FlinkConfigManager configManager;
    private final Clock clock;
    private final Map<ResourceID, KubernetesResourceNamespaceMetricGroup> resourceNsMetricGroups = new ConcurrentHashMap<ResourceID, KubernetesResourceNamespaceMetricGroup>();
    private final Map<ResourceID, KubernetesResourceMetricGroup> resourceMetricGroups = new ConcurrentHashMap<ResourceID, KubernetesResourceMetricGroup>();
    private final Map<List<String>, Histogram> histograms = new ConcurrentHashMap<List<String>, Histogram>();
    private final Map<List<String>, Counter> counters = new ConcurrentHashMap<List<String>, Counter>();

    public OperatorJosdkMetrics(KubernetesOperatorMetricGroup operatorMetricGroup, FlinkConfigManager configManager) {
        this.operatorMetricGroup = operatorMetricGroup;
        this.configManager = configManager;
        this.clock = SystemClock.getInstance();
    }

    public <T> T timeControllerExecution(Metrics.ControllerExecution<T> execution) throws Exception {
        long startTime = this.clock.relativeTimeNanos();
        try {
            Object result = execution.execute();
            this.histogram(execution, execution.successTypeName(result)).update(this.toSeconds(startTime));
            return (T)result;
        }
        catch (Exception e) {
            this.histogram(execution, "failed").update(this.toSeconds(startTime));
            throw e;
        }
    }

    public void receivedEvent(Event event, Map<String, Object> metadata) {
        if (event instanceof ResourceEvent) {
            ResourceAction action = ((ResourceEvent)event).getAction();
            this.counter((MetricGroup)this.getResourceMg(event.getRelatedCustomResourceID(), metadata), RESOURCE, EVENT).inc();
            this.counter((MetricGroup)this.getResourceMg(event.getRelatedCustomResourceID(), metadata), RESOURCE, EVENT, action.name()).inc();
        }
    }

    public void cleanupDoneFor(ResourceID resourceID, Map<String, Object> metadata) {
        this.counter((MetricGroup)this.getResourceMg(resourceID, metadata), RECONCILIATION, "cleanup").inc();
    }

    public void reconcileCustomResource(ResourceID resourceID, RetryInfo retryInfoNullable, Map<String, Object> metadata) {
        this.counter((MetricGroup)this.getResourceMg(resourceID, metadata), RECONCILIATION).inc();
        if (retryInfoNullable != null) {
            this.counter((MetricGroup)this.getResourceMg(resourceID, metadata), RECONCILIATION, "retries").inc();
        }
    }

    public void finishedReconciliation(ResourceID resourceID, Map<String, Object> metadata) {
        this.counter((MetricGroup)this.getResourceMg(resourceID, metadata), RECONCILIATION, "finished").inc();
    }

    public void failedReconciliation(ResourceID resourceID, Exception exception, Map<String, Object> metadata) {
        this.counter((MetricGroup)this.getResourceMg(resourceID, metadata), RECONCILIATION, "failed").inc();
    }

    public <T extends Map<?, ?>> T monitorSizeOf(T map, String name) {
        this.operatorMetricGroup.addGroup(OPERATOR_SDK_GROUP).addGroup(name).gauge("size", map::size);
        return map;
    }

    private Histogram histogram(Metrics.ControllerExecution<?> execution, String name) {
        List<String> groups = this.getHistoGroups(execution, name);
        return this.histograms.computeIfAbsent(groups, k -> {
            MetricGroup group = this.getResourceNsMg(execution.resourceID(), execution.metadata()).addGroup(OPERATOR_SDK_GROUP);
            for (String mg : groups) {
                group = group.addGroup(mg);
            }
            MetricGroup finalGroup = group;
            return finalGroup.histogram("TimeSeconds", OperatorMetricUtils.createHistogram(this.configManager.getOperatorConfiguration()));
        });
    }

    private List<String> getHistoGroups(Metrics.ControllerExecution<?> execution, String name) {
        return List.of(execution.name(), name);
    }

    private long toSeconds(long startTime) {
        return TimeUnit.NANOSECONDS.toSeconds(this.clock.relativeTimeNanos() - startTime);
    }

    private Counter counter(MetricGroup parent, String ... names) {
        ArrayList key = new ArrayList(parent.getScopeComponents().length + names.length);
        Arrays.stream(parent.getScopeComponents()).forEach(key::add);
        Arrays.stream(names).forEach(key::add);
        return this.counters.computeIfAbsent(key, s -> {
            MetricGroup group = parent.addGroup(OPERATOR_SDK_GROUP);
            for (String name : names) {
                group = group.addGroup(name);
            }
            MetricGroup finalGroup = group;
            return OperatorMetricUtils.synchronizedCounter(finalGroup.counter("Count"));
        });
    }

    private KubernetesResourceNamespaceMetricGroup getResourceNsMg(ResourceID resourceID, Map<String, Object> metadata) {
        Class<? extends CustomResource<?, ?>> resourceClass = this.getResourceClass(metadata).orElseThrow(() -> new RuntimeException("Unknown resource kind for " + resourceID));
        return this.resourceNsMetricGroups.computeIfAbsent(resourceID, rid -> this.operatorMetricGroup.createResourceNamespaceGroup(this.configManager.getDefaultConfig(), resourceClass, rid.getNamespace().orElse("default")));
    }

    private Optional<Class<? extends CustomResource<?, ?>>> getResourceClass(Map<String, Object> metadata) {
        Class<FlinkDeployment> resourceClass;
        GroupVersionKind resourceGvk = (GroupVersionKind)metadata.get("josdk.resource.gvk");
        if (resourceGvk == null) {
            return Optional.empty();
        }
        if (resourceGvk.getKind().equals(FlinkDeployment.class.getSimpleName())) {
            resourceClass = FlinkDeployment.class;
        } else if (resourceGvk.getKind().equals(FlinkSessionJob.class.getSimpleName())) {
            resourceClass = FlinkSessionJob.class;
        } else if (resourceGvk.getKind().equals(FlinkStateSnapshot.class.getSimpleName())) {
            resourceClass = FlinkStateSnapshot.class;
        } else {
            return Optional.empty();
        }
        return Optional.of(resourceClass);
    }

    private KubernetesResourceMetricGroup getResourceMg(ResourceID resourceID, Map<String, Object> metadata) {
        return this.resourceMetricGroups.computeIfAbsent(resourceID, rid -> this.getResourceNsMg((ResourceID)rid, metadata).createResourceGroup(this.configManager.getDefaultConfig(), rid.getName()));
    }
}

