/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;

public class KubernetesOperatorMetricOptions {
    public static final ConfigOption<Boolean> OPERATOR_JVM_METRICS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("jvm.metrics.enabled").booleanType().defaultValue((Object)true).withDescription("Enable Kubernetes Operator JVM metrics.");
    public static final ConfigOption<Boolean> OPERATOR_JOSDK_METRICS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("josdk.metrics.enabled").booleanType().defaultValue((Object)true).withDescription("Enable forwarding of Java Operator SDK metrics to the Flink metric registry.");
    public static final ConfigOption<Boolean> OPERATOR_KUBERNETES_CLIENT_METRICS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("kubernetes.client.metrics.enabled").booleanType().defaultValue((Object)true).withDescription("Enable KubernetesClient metrics for measuring the HTTP traffic to the Kubernetes API Server.");
    public static final ConfigOption<Boolean> OPERATOR_KUBERNETES_CLIENT_METRICS_HTTP_RESPONSE_CODE_GROUPS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("kubernetes.client.metrics.http.response.code.groups.enabled").booleanType().defaultValue((Object)false).withDescription("Enable KubernetesClient metrics for measuring the HTTP traffic to the Kubernetes API Server by response code group, e.g. 1xx, 2xx.");
    public static final ConfigOption<Duration> OPERATOR_KUBERNETES_SLOW_REQUEST_THRESHOLD = KubernetesOperatorConfigOptions.operatorConfig("kubernetes.client.metrics.slow.request.threshold").durationType().defaultValue((Object)Duration.ofSeconds(5L)).withDescription("Threshold value that triggers slow request counter for Kubernetes client metrics");
    public static final ConfigOption<Boolean> OPERATOR_RESOURCE_METRICS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("resource.metrics.enabled").booleanType().defaultValue((Object)true).withDescription("Enables metrics for FlinkDeployment and FlinkSessionJob custom resources.");
    public static final ConfigOption<Boolean> OPERATOR_LIFECYCLE_METRICS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("resource.lifecycle.metrics.enabled").booleanType().defaultValue((Object)true).withDescription("Enable resource lifecycle state metrics. This enables both state and transition counts/histograms.");
    public static final ConfigOption<Boolean> OPERATOR_LIFECYCLE_NAMESPACE_HISTOGRAMS_ENABLED = KubernetesOperatorConfigOptions.operatorConfig("resource.lifecycle.namespace.histograms.enabled").booleanType().defaultValue((Object)true).withDescription("In addition to the system level histograms, enable per namespace tracking of state and transition times.");
    public static final ConfigOption<Integer> OPERATOR_METRICS_HISTOGRAM_SAMPLE_SIZE = KubernetesOperatorConfigOptions.operatorConfig("metrics.histogram.sample.size").intType().defaultValue((Object)1000).withDescription("Defines the number of measured samples when calculating statistics.");
    public static final ConfigOption<String> SCOPE_NAMING_KUBERNETES_OPERATOR = KubernetesOperatorConfigOptions.operatorConfig("metrics.scope.k8soperator.system").stringType().defaultValue((Object)"<host>.k8soperator.<namespace>.<name>.system").withDeprecatedKeys(new String[]{"metrics.scope.k8soperator"}).withDescription("Defines the scope format string that is applied to all metrics scoped to the kubernetes operator.");
    public static final ConfigOption<String> SCOPE_NAMING_KUBERNETES_OPERATOR_RESOURCENS = KubernetesOperatorConfigOptions.operatorConfig("metrics.scope.k8soperator.resourcens").stringType().defaultValue((Object)"<host>.k8soperator.<namespace>.<name>.namespace.<resourcens>.<resourcetype>").withDeprecatedKeys(new String[]{"metrics.scope.k8soperator.resourcens"}).withDescription("Defines the scope format string that is applied to all metrics scoped to the kubernetes operator resource namespace.");
    public static final ConfigOption<String> SCOPE_NAMING_KUBERNETES_OPERATOR_RESOURCE = KubernetesOperatorConfigOptions.operatorConfig("metrics.scope.k8soperator.resource").stringType().defaultValue((Object)"<host>.k8soperator.<namespace>.<name>.resource.<resourcens>.<resourcename>.<resourcetype>").withDeprecatedKeys(new String[]{"metrics.scope.k8soperator.resource"}).withDescription("Defines the scope format string that is applied to all metrics scoped to the kubernetes operator resource.");
}

