/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.OperatorMetricUtils;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;

public class KubernetesClientMetrics
implements Interceptor {
    public static final String KUBE_CLIENT_GROUP = "KubeClient";
    public static final String HTTP_REQUEST_GROUP = "HttpRequest";
    public static final String HTTP_REQUEST_FAILED_GROUP = "Failed";
    public static final String HTTP_REQUEST_SLOW_GROUP = "Slow";
    public static final String HTTP_RESPONSE_GROUP = "HttpResponse";
    public static final String HTTP_RESPONSE_1XX = "1xx";
    public static final String HTTP_RESPONSE_2XX = "2xx";
    public static final String HTTP_RESPONSE_3XX = "3xx";
    public static final String HTTP_RESPONSE_4XX = "4xx";
    public static final String HTTP_RESPONSE_5XX = "5xx";
    public static final String COUNTER = "Count";
    public static final String METER = "NumPerSecond";
    public static final String HISTO = "TimeNanos";
    public static final String REQUEST_START_TIME_HEADER = "requestStartTimeNanos";
    private final Histogram responseLatency;
    private final MetricGroup requestMetricGroup;
    private final MetricGroup failedRequestMetricGroup;
    private final MetricGroup slowRequestMetricGroup;
    private final MetricGroup responseMetricGroup;
    private final Counter requestCounter;
    private final Counter failedRequestCounter;
    private final Counter slowRequestCounter;
    private final Counter responseCounter;
    private final OperatorMetricUtils.SynchronizedMeterView requestRateMeter;
    private final OperatorMetricUtils.SynchronizedMeterView requestFailedRateMeter;
    private final OperatorMetricUtils.SynchronizedMeterView responseRateMeter;
    private final boolean httpResponseCodeGroupsEnabled;
    private final List<OperatorMetricUtils.SynchronizedMeterView> responseCodeGroupMeters = new ArrayList<OperatorMetricUtils.SynchronizedMeterView>(5);
    private final Map<Integer, OperatorMetricUtils.SynchronizedMeterView> responseCodeMeters = new ConcurrentHashMap<Integer, OperatorMetricUtils.SynchronizedMeterView>();
    private final Map<String, Counter> requestMethodCounter = new ConcurrentHashMap<String, Counter>();
    private final LongSupplier nanoTimeSource;
    private final Duration slowRequestThreshold;

    public KubernetesClientMetrics(MetricGroup parentGroup, FlinkOperatorConfiguration flinkOperatorConfiguration) {
        this(parentGroup, flinkOperatorConfiguration, System::nanoTime);
    }

    public KubernetesClientMetrics(MetricGroup parentGroup, FlinkOperatorConfiguration flinkOperatorConfiguration, LongSupplier nanoTimeSource) {
        this.nanoTimeSource = nanoTimeSource;
        MetricGroup metricGroup = parentGroup.addGroup(KUBE_CLIENT_GROUP);
        this.requestMetricGroup = metricGroup.addGroup(HTTP_REQUEST_GROUP);
        this.failedRequestMetricGroup = this.requestMetricGroup.addGroup(HTTP_REQUEST_FAILED_GROUP);
        this.slowRequestMetricGroup = this.requestMetricGroup.addGroup(HTTP_REQUEST_SLOW_GROUP);
        this.responseMetricGroup = metricGroup.addGroup(HTTP_RESPONSE_GROUP);
        this.requestCounter = OperatorMetricUtils.synchronizedCounter(this.requestMetricGroup.counter(COUNTER));
        this.failedRequestCounter = OperatorMetricUtils.synchronizedCounter(this.failedRequestMetricGroup.counter(COUNTER));
        this.slowRequestThreshold = flinkOperatorConfiguration.getSlowRequestThreshold();
        this.slowRequestCounter = OperatorMetricUtils.synchronizedCounter(this.slowRequestMetricGroup.counter(COUNTER));
        this.responseCounter = OperatorMetricUtils.synchronizedCounter(this.responseMetricGroup.counter(COUNTER));
        this.requestRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.requestMetricGroup.meter(METER, (Meter)new MeterView(this.requestCounter)));
        this.requestFailedRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.failedRequestMetricGroup.meter(METER, (Meter)new MeterView(this.failedRequestCounter)));
        this.responseRateMeter = OperatorMetricUtils.synchronizedMeterView((MeterView)this.responseMetricGroup.meter(METER, (Meter)new MeterView(this.responseCounter)));
        this.responseLatency = this.responseMetricGroup.histogram(HISTO, OperatorMetricUtils.createHistogram(flinkOperatorConfiguration));
        this.httpResponseCodeGroupsEnabled = flinkOperatorConfiguration.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled();
        if (this.httpResponseCodeGroupsEnabled) {
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_1XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_2XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_3XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_4XX)));
            this.responseCodeGroupMeters.add(this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(HTTP_RESPONSE_5XX)));
        }
    }

    public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
        long requestStartTime = this.nanoTimeSource.getAsLong();
        builder.setHeader(REQUEST_START_TIME_HEADER, String.valueOf(requestStartTime));
        this.updateRequestMetrics(request);
    }

    public void after(HttpRequest request, HttpResponse<?> response, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        this.trackRequestLatency(request);
        this.updateResponseMetrics(response);
    }

    public CompletableFuture<Boolean> afterFailure(BasicBuilder builder, HttpResponse<?> response, Interceptor.RequestTags tags) {
        this.requestFailedRateMeter.markEvent();
        return CompletableFuture.completedFuture(false);
    }

    public void afterConnectionFailure(HttpRequest request, Throwable failure) {
        this.trackRequestLatency(request);
        this.requestFailedRateMeter.markEvent();
    }

    @VisibleForTesting
    Counter getRequestCounter() {
        return this.requestCounter;
    }

    @VisibleForTesting
    Counter getResponseCounter() {
        return this.responseCounter;
    }

    @VisibleForTesting
    Counter getRequestMethodCounter(String method) {
        return this.requestMethodCounter.get(method);
    }

    @VisibleForTesting
    OperatorMetricUtils.SynchronizedMeterView getRequestRateMeter() {
        return this.requestRateMeter;
    }

    @VisibleForTesting
    OperatorMetricUtils.SynchronizedMeterView getResponseCodeMeter(int statusCode) {
        return this.responseCodeMeters.get(statusCode);
    }

    @VisibleForTesting
    List<OperatorMetricUtils.SynchronizedMeterView> getResponseCodeGroupMeters() {
        return this.responseCodeGroupMeters;
    }

    @VisibleForTesting
    Histogram getResponseLatency() {
        return this.responseLatency;
    }

    @VisibleForTesting
    public Counter getSlowRequestCounter() {
        return this.slowRequestCounter;
    }

    @VisibleForTesting
    public Duration getSlowRequestThreshold() {
        return this.slowRequestThreshold;
    }

    @VisibleForTesting
    OperatorMetricUtils.SynchronizedMeterView getRequestFailedRateMeter() {
        return this.requestFailedRateMeter;
    }

    private void updateRequestMetrics(HttpRequest request) {
        this.requestRateMeter.markEvent();
        this.getCounterByRequestMethod(request.method()).inc();
    }

    private void updateResponseMetrics(HttpResponse<?> response) {
        if (response != null) {
            this.responseRateMeter.markEvent();
            this.getMeterViewByResponseCode(response.code()).markEvent();
            if (this.httpResponseCodeGroupsEnabled) {
                this.responseCodeGroupMeters.get(response.code() / 100 - 1).markEvent();
            }
        } else {
            this.requestFailedRateMeter.markEvent();
        }
    }

    private void trackRequestLatency(HttpRequest request) {
        String header = request.header(REQUEST_START_TIME_HEADER);
        if (header != null) {
            long currentNanos = this.nanoTimeSource.getAsLong();
            long requestStartNanos = Long.parseLong(header);
            long latency = currentNanos - requestStartNanos;
            this.responseLatency.update(latency);
            if (latency >= this.slowRequestThreshold.toNanos()) {
                this.slowRequestCounter.inc();
            }
        }
    }

    private Counter getCounterByRequestMethod(String method) {
        return this.requestMethodCounter.computeIfAbsent(method, key -> OperatorMetricUtils.synchronizedCounter(this.requestMetricGroup.addGroup(key).counter(COUNTER)));
    }

    private OperatorMetricUtils.SynchronizedMeterView getMeterViewByResponseCode(int code) {
        return this.responseCodeMeters.computeIfAbsent(code, key -> this.createMeterViewForMetricsGroup(this.responseMetricGroup.addGroup(key.intValue())));
    }

    private OperatorMetricUtils.SynchronizedMeterView createMeterViewForMetricsGroup(MetricGroup metricGroup) {
        return OperatorMetricUtils.synchronizedMeterView((MeterView)metricGroup.meter(METER, (Meter)new MeterView(OperatorMetricUtils.synchronizedCounter(metricGroup.counter(COUNTER)))));
    }
}

