/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkStateSnapshotSpec;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceNamespaceMetricGroup;

public class FlinkStateSnapshotMetrics
implements CustomResourceMetrics<FlinkStateSnapshot> {
    private final KubernetesOperatorMetricGroup parentMetricGroup;
    private final Configuration configuration;
    private final Map<String, Map<FlinkStateSnapshotStatus.State, Set<String>>> checkpointStatuses = new ConcurrentHashMap<String, Map<FlinkStateSnapshotStatus.State, Set<String>>>();
    private final Map<String, Map<FlinkStateSnapshotStatus.State, Set<String>>> savepointStatuses = new ConcurrentHashMap<String, Map<FlinkStateSnapshotStatus.State, Set<String>>>();
    public static final String COUNTER_GROUP_NAME = "Count";
    public static final String STATE_GROUP_NAME = "State";
    public static final String CHECKPOINT_GROUP_NAME = "Checkpoint";
    public static final String SAVEPOINT_GROUP_NAME = "Savepoint";

    public FlinkStateSnapshotMetrics(KubernetesOperatorMetricGroup parentMetricGroup, Configuration configuration) {
        this.parentMetricGroup = parentMetricGroup;
        this.configuration = configuration;
    }

    @Override
    public void onUpdate(FlinkStateSnapshot snapshot) {
        if (snapshot.getStatus() == null || ((FlinkStateSnapshotStatus)snapshot.getStatus()).getState() == null) {
            return;
        }
        this.onRemove(snapshot);
        ((Set)this.getSnapshotMap(snapshot).computeIfAbsent(snapshot.getMetadata().getNamespace(), ns -> {
            this.initNamespaceSnapshotStates((String)ns);
            this.initNamespaceSnapshotCounts((String)ns);
            return this.createSnapshotStateMap();
        }).get(((FlinkStateSnapshotStatus)snapshot.getStatus()).getState())).add(snapshot.getMetadata().getName());
    }

    @Override
    public void onRemove(FlinkStateSnapshot snapshot) {
        String namespace = snapshot.getMetadata().getNamespace();
        String name = snapshot.getMetadata().getName();
        Map<String, Map<FlinkStateSnapshotStatus.State, Set<String>>> snapshotMap = this.getSnapshotMap(snapshot);
        if (snapshotMap.containsKey(namespace)) {
            snapshotMap.get(namespace).values().forEach(names -> names.remove(name));
        }
    }

    private Map<String, Map<FlinkStateSnapshotStatus.State, Set<String>>> getSnapshotMap(FlinkStateSnapshot snapshot) {
        if (((FlinkStateSnapshotSpec)snapshot.getSpec()).isSavepoint()) {
            return this.savepointStatuses;
        }
        return this.checkpointStatuses;
    }

    private void initNamespaceSnapshotCounts(String ns) {
        KubernetesResourceNamespaceMetricGroup mainGroup = this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkStateSnapshot.class, ns);
        mainGroup.addGroup(CHECKPOINT_GROUP_NAME).gauge(COUNTER_GROUP_NAME, () -> {
            if (!this.checkpointStatuses.containsKey(ns)) {
                return 0;
            }
            return this.checkpointStatuses.get(ns).values().stream().mapToInt(Set::size).sum();
        });
        mainGroup.addGroup(SAVEPOINT_GROUP_NAME).gauge(COUNTER_GROUP_NAME, () -> {
            if (!this.savepointStatuses.containsKey(ns)) {
                return 0;
            }
            return this.savepointStatuses.get(ns).values().stream().mapToInt(Set::size).sum();
        });
    }

    private void initNamespaceSnapshotStates(String ns) {
        KubernetesResourceNamespaceMetricGroup mainGroup = this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkStateSnapshot.class, ns);
        for (FlinkStateSnapshotStatus.State state : FlinkStateSnapshotStatus.State.values()) {
            mainGroup.addGroup(CHECKPOINT_GROUP_NAME).addGroup(STATE_GROUP_NAME).addGroup(state.toString()).gauge(COUNTER_GROUP_NAME, () -> Optional.ofNullable(this.checkpointStatuses.get(ns)).map(s -> ((Set)s.get(state)).size()).orElse(0));
            mainGroup.addGroup(SAVEPOINT_GROUP_NAME).addGroup(STATE_GROUP_NAME).addGroup(state.toString()).gauge(COUNTER_GROUP_NAME, () -> Optional.ofNullable(this.savepointStatuses.get(ns)).map(s -> ((Set)s.get(state)).size()).orElse(0));
        }
    }

    private Map<FlinkStateSnapshotStatus.State, Set<String>> createSnapshotStateMap() {
        ConcurrentHashMap<FlinkStateSnapshotStatus.State, Set<String>> statuses = new ConcurrentHashMap<FlinkStateSnapshotStatus.State, Set<String>>();
        for (FlinkStateSnapshotStatus.State state : FlinkStateSnapshotStatus.State.values()) {
            statuses.put(state, ConcurrentHashMap.newKeySet());
        }
        return statuses;
    }
}

