/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.metrics;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.JobManagerDeploymentStatus;
import org.apache.flink.kubernetes.operator.metrics.CustomResourceMetrics;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricGroup;
import org.apache.flink.util.StringUtils;

public class FlinkDeploymentMetrics
implements CustomResourceMetrics<FlinkDeployment> {
    private final KubernetesOperatorMetricGroup parentMetricGroup;
    private final Configuration configuration;
    private final Map<String, Map<JobManagerDeploymentStatus, Set<String>>> deploymentStatuses = new ConcurrentHashMap<String, Map<JobManagerDeploymentStatus, Set<String>>>();
    private final Map<String, Map<String, Set<String>>> deploymentFlinkVersions = new ConcurrentHashMap<String, Map<String, Set<String>>>();
    private final Map<String, Map<String, Set<String>>> deploymentFlinkMinorVersions = new ConcurrentHashMap<String, Map<String, Set<String>>>();
    private final Map<String, Map<String, Double>> deploymentCpuUsage = new ConcurrentHashMap<String, Map<String, Double>>();
    private final Map<String, Map<String, Long>> deploymentMemoryUsage = new ConcurrentHashMap<String, Map<String, Long>>();
    private final Map<String, Map<String, Long>> deploymentStateSize = new ConcurrentHashMap<String, Map<String, Long>>();
    public static final String FLINK_VERSION_GROUP_NAME = "FlinkVersion";
    public static final String FLINK_MINOR_VERSION_GROUP_NAME = "FlinkMinorVersion";
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final String MALFORMED_MINOR_VERSION = "MALFORMED";
    public static final String STATUS_GROUP_NAME = "JmDeploymentStatus";
    public static final String RESOURCE_USAGE_GROUP_NAME = "ResourceUsage";
    public static final String COUNTER_NAME = "Count";
    public static final String CPU_NAME = "Cpu";
    public static final String MEMORY_NAME = "Memory";
    public static final String STATE_SIZE = "StateSize";

    public FlinkDeploymentMetrics(KubernetesOperatorMetricGroup parentMetricGroup, Configuration configuration) {
        this.parentMetricGroup = parentMetricGroup;
        this.configuration = configuration;
    }

    @Override
    public void onUpdate(FlinkDeployment flinkApp) {
        this.onRemove(flinkApp);
        String namespace = flinkApp.getMetadata().getNamespace();
        Map clusterInfo = ((FlinkDeploymentStatus)flinkApp.getStatus()).getClusterInfo();
        String deploymentName = flinkApp.getMetadata().getName();
        ((Set)this.deploymentStatuses.computeIfAbsent(namespace, ns -> {
            this.initNamespaceDeploymentCounts((String)ns);
            this.initNamespaceStatusCounts((String)ns);
            return this.createDeploymentStatusMap();
        }).get(((FlinkDeploymentStatus)flinkApp.getStatus()).getJobManagerDeploymentStatus())).add(deploymentName);
        String flinkVersion = ((FlinkDeploymentStatus)flinkApp.getStatus()).getClusterInfo().getOrDefault("flink-version", "");
        if (StringUtils.isNullOrWhitespaceOnly((String)flinkVersion)) {
            flinkVersion = UNKNOWN_VERSION;
        }
        this.deploymentFlinkVersions.computeIfAbsent(namespace, ns -> new ConcurrentHashMap()).computeIfAbsent(flinkVersion, v -> {
            this.initFlinkVersions(namespace, (String)v);
            return ConcurrentHashMap.newKeySet();
        }).add(deploymentName);
        String[] subVersions = flinkVersion.split("\\.");
        String minorVersion = MALFORMED_MINOR_VERSION;
        if (subVersions.length >= 2) {
            minorVersion = subVersions[0].concat(".").concat(subVersions[1]);
        }
        this.deploymentFlinkMinorVersions.computeIfAbsent(namespace, ns -> new ConcurrentHashMap()).computeIfAbsent(minorVersion, v -> {
            this.initFlinkMinorVersions(namespace, (String)v);
            return ConcurrentHashMap.newKeySet();
        }).add(deploymentName);
        double totalCpu = NumberUtils.toDouble((String)clusterInfo.getOrDefault("total-cpu", "0"));
        if (!Double.isFinite(totalCpu)) {
            totalCpu = 0.0;
        }
        this.deploymentCpuUsage.computeIfAbsent(namespace, ns -> {
            this.initNamespaceCpuUsage((String)ns);
            return new ConcurrentHashMap();
        }).put(deploymentName, totalCpu);
        this.deploymentMemoryUsage.computeIfAbsent(namespace, ns -> {
            this.initNamespaceMemoryUsage((String)ns);
            return new ConcurrentHashMap();
        }).put(deploymentName, NumberUtils.toLong((String)clusterInfo.getOrDefault("total-memory", "0")));
        long stateSize = NumberUtils.toLong((String)clusterInfo.getOrDefault("state-size", "0"));
        this.deploymentStateSize.computeIfAbsent(namespace, ns -> {
            this.initNamespaceStateSize((String)ns);
            return new ConcurrentHashMap();
        }).put(deploymentName, stateSize > 0L ? stateSize : 0L);
    }

    @Override
    public void onRemove(FlinkDeployment flinkApp) {
        String namespace = flinkApp.getMetadata().getNamespace();
        String name = flinkApp.getMetadata().getName();
        if (this.deploymentStatuses.containsKey(namespace)) {
            this.deploymentStatuses.get(namespace).values().forEach(names -> names.remove(name));
        }
        if (this.deploymentFlinkVersions.containsKey(namespace)) {
            this.deploymentFlinkVersions.get(namespace).values().forEach(names -> names.remove(name));
        }
        if (this.deploymentFlinkMinorVersions.containsKey(namespace)) {
            this.deploymentFlinkMinorVersions.get(namespace).values().forEach(names -> names.remove(name));
        }
        if (this.deploymentCpuUsage.containsKey(namespace)) {
            this.deploymentCpuUsage.get(namespace).remove(name);
        }
        if (this.deploymentMemoryUsage.containsKey(namespace)) {
            this.deploymentMemoryUsage.get(namespace).remove(name);
        }
        if (this.deploymentStateSize.containsKey(namespace)) {
            this.deploymentStateSize.get(namespace).remove(name);
        }
    }

    private void initNamespaceDeploymentCounts(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).gauge(COUNTER_NAME, () -> this.deploymentStatuses.get(ns).values().stream().mapToInt(Set::size).sum());
    }

    private void initNamespaceStatusCounts(String ns) {
        for (JobManagerDeploymentStatus status : JobManagerDeploymentStatus.values()) {
            this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(STATUS_GROUP_NAME).addGroup(status.toString()).gauge(COUNTER_NAME, () -> this.deploymentStatuses.get(ns).get(status).size());
        }
    }

    private void initFlinkVersions(String ns, String flinkVersion) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(FLINK_VERSION_GROUP_NAME, flinkVersion).gauge(COUNTER_NAME, () -> this.deploymentFlinkVersions.get(ns).get(flinkVersion).size());
    }

    private void initFlinkMinorVersions(String ns, String minorVersion) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(FLINK_MINOR_VERSION_GROUP_NAME, minorVersion).gauge(COUNTER_NAME, () -> this.deploymentFlinkMinorVersions.get(ns).get(minorVersion).size());
    }

    private void initNamespaceCpuUsage(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(RESOURCE_USAGE_GROUP_NAME).gauge(CPU_NAME, () -> this.deploymentCpuUsage.get(ns).values().stream().reduce(0.0, Double::sum));
    }

    private void initNamespaceMemoryUsage(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(RESOURCE_USAGE_GROUP_NAME).gauge(MEMORY_NAME, () -> this.deploymentMemoryUsage.get(ns).values().stream().reduce(0L, Long::sum));
    }

    private void initNamespaceStateSize(String ns) {
        this.parentMetricGroup.createResourceNamespaceGroup(this.configuration, FlinkDeployment.class, ns).addGroup(RESOURCE_USAGE_GROUP_NAME).gauge(STATE_SIZE, () -> this.deploymentStateSize.get(ns).values().stream().reduce(0L, Long::sum));
    }

    private Map<JobManagerDeploymentStatus, Set<String>> createDeploymentStatusMap() {
        ConcurrentHashMap<JobManagerDeploymentStatus, Set<String>> statuses = new ConcurrentHashMap<JobManagerDeploymentStatus, Set<String>>();
        for (JobManagerDeploymentStatus status : JobManagerDeploymentStatus.values()) {
            statuses.put(status, ConcurrentHashMap.newKeySet());
        }
        return statuses;
    }
}

