/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.listener;

import io.fabric8.kubernetes.api.model.Event;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.api.listener.FlinkResourceListener;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuditUtils.class);

    public static void logContext(FlinkResourceListener.FlinkStateSnapshotStatusUpdateContext ctx) {
        LOG.info(AuditUtils.format(ctx.getNewStatus()));
    }

    public static void logContext(FlinkResourceListener.FlinkStateSnapshotEventContext ctx) {
        LOG.info(AuditUtils.format(ctx.getEvent(), "Snapshot"));
    }

    public static <R extends AbstractFlinkResource<?, S>, S extends CommonStatus<?>> void logContext(FlinkResourceListener.StatusUpdateContext<R, S> ctx) {
        if (ctx.getPreviousStatus().getLifecycleState() == ctx.getNewStatus().getLifecycleState()) {
            return;
        }
        LOG.info(AuditUtils.format(ctx.getNewStatus()));
    }

    public static <R extends AbstractFlinkResource<?, ?>> void logContext(FlinkResourceListener.ResourceEventContext<R> ctx) {
        LOG.info(AuditUtils.format(ctx.getEvent(), "Job"));
    }

    private static String format(@NonNull CommonStatus<?> status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        ResourceLifecycleState lifeCycleState = status.getLifecycleState();
        return String.format(">>> %-16s | %-7s | %-15s | %s ", "Status[Job]", StringUtils.isEmpty((CharSequence)status.getError()) ? "Info" : "Error", lifeCycleState, StringUtils.isEmpty((CharSequence)status.getError()) ? lifeCycleState.getDescription() : status.getError());
    }

    private static String format(@NonNull FlinkStateSnapshotStatus status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        String message = (String)ObjectUtils.firstNonNull((Object[])new String[]{status.getError(), status.getPath(), ""});
        return String.format(">>> %-16s | %-7s | %s", "Status[Snapshot]", status.getState(), message);
    }

    @VisibleForTesting
    public static String format(@NonNull Event event, String component) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        String componentMessage = String.format("Event[%s]", component);
        return String.format(">>> %-16s | %-7s | %-15s | %s", componentMessage, event.getType().equals("Normal") ? "Info" : event.getType(), event.getReason().toUpperCase(), event.getMessage());
    }
}

