/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.health.HealthProbe;
import org.apache.flink.kubernetes.operator.health.HttpBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorHealthService {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorHealthService.class);
    private final HealthProbe probe = HealthProbe.INSTANCE;
    private final FlinkConfigManager configManager;
    private HttpBootstrap httpBootstrap = null;

    public OperatorHealthService(FlinkConfigManager configManager) {
        this.configManager = configManager;
    }

    public void start() {
        try {
            this.httpBootstrap = new HttpBootstrap(this.probe, (Integer)this.configManager.getDefaultConfig().get(KubernetesOperatorConfigOptions.OPERATOR_HEALTH_PROBE_PORT));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.httpBootstrap.stop();
    }

    public static OperatorHealthService fromConfig(FlinkConfigManager configManager) {
        Configuration defaultConfig = configManager.getDefaultConfig();
        if (defaultConfig.getBoolean(KubernetesOperatorConfigOptions.OPERATOR_HEALTH_PROBE_ENABLED)) {
            return new OperatorHealthService(configManager);
        }
        LOG.info("Health probe disabled");
        return null;
    }
}

