/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import io.javaoperatorsdk.operator.RuntimeInfo;
import io.javaoperatorsdk.operator.health.InformerHealthIndicator;
import io.javaoperatorsdk.operator.health.InformerWrappingEventSourceHealthIndicator;
import io.javaoperatorsdk.operator.health.Status;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kubernetes.operator.health.InformerIdentifier;

public final class InformerHealthSummary {
    private final boolean anyHealthy;
    private final Set<InformerIdentifier> unhealthyInformers;

    public static InformerHealthSummary fromRuntimeInfo(RuntimeInfo runtimeInfo) {
        HashSet<InformerIdentifier> newUnHealthy = new HashSet<InformerIdentifier>();
        boolean anyHealthy = false;
        for (Map.Entry controllerEntry : runtimeInfo.unhealthyInformerWrappingEventSourceHealthIndicator().entrySet()) {
            for (Map.Entry eventSourceEntry : ((Map)controllerEntry.getValue()).entrySet()) {
                Map informers = ((InformerWrappingEventSourceHealthIndicator)eventSourceEntry.getValue()).informerHealthIndicators();
                for (Map.Entry informerEntry : informers.entrySet()) {
                    if (((InformerHealthIndicator)informerEntry.getValue()).getStatus() == Status.HEALTHY) {
                        anyHealthy = true;
                        continue;
                    }
                    newUnHealthy.add(new InformerIdentifier((String)controllerEntry.getKey(), (String)eventSourceEntry.getKey(), (String)informerEntry.getKey()));
                }
            }
        }
        return new InformerHealthSummary(anyHealthy || newUnHealthy.isEmpty(), newUnHealthy);
    }

    public InformerHealthSummary(boolean anyHealthy, Set<InformerIdentifier> unhealthyInformers) {
        this.anyHealthy = anyHealthy;
        this.unhealthyInformers = unhealthyInformers;
    }

    public boolean isAnyHealthy() {
        return this.anyHealthy;
    }

    public Set<InformerIdentifier> getUnhealthyInformers() {
        return this.unhealthyInformers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InformerHealthSummary)) {
            return false;
        }
        InformerHealthSummary other = (InformerHealthSummary)o;
        if (this.isAnyHealthy() != other.isAnyHealthy()) {
            return false;
        }
        Set<InformerIdentifier> this$unhealthyInformers = this.getUnhealthyInformers();
        Set<InformerIdentifier> other$unhealthyInformers = other.getUnhealthyInformers();
        return !(this$unhealthyInformers == null ? other$unhealthyInformers != null : !((Object)this$unhealthyInformers).equals(other$unhealthyInformers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnyHealthy() ? 79 : 97);
        Set<InformerIdentifier> $unhealthyInformers = this.getUnhealthyInformers();
        result = result * 59 + ($unhealthyInformers == null ? 43 : ((Object)$unhealthyInformers).hashCode());
        return result;
    }

    public String toString() {
        return "InformerHealthSummary(anyHealthy=" + this.isAnyHealthy() + ", unhealthyInformers=" + this.getUnhealthyInformers() + ")";
    }
}

