/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.health;

import io.javaoperatorsdk.operator.RuntimeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.kubernetes.operator.health.CanaryResourceManager;
import org.apache.flink.kubernetes.operator.health.InformerHealthSummary;
import org.apache.flink.kubernetes.operator.health.InformerIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HealthProbe {
    INSTANCE;

    private static final Logger LOG;
    private RuntimeInfo runtimeInfo;
    private InformerHealthSummary previousInformerHealthSummary;
    private final List<CanaryResourceManager<?>> canaryResourceManagers = new ArrayList();

    public void registerCanaryResourceManager(CanaryResourceManager<?> canaryResourceManager) {
        this.canaryResourceManagers.add(canaryResourceManager);
    }

    public void setRuntimeInfo(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
        this.previousInformerHealthSummary = InformerHealthSummary.fromRuntimeInfo(runtimeInfo);
        LOG.info("Initially unhealthy informers: {}", this.previousInformerHealthSummary.getUnhealthyInformers());
    }

    public boolean isHealthy() {
        if (this.runtimeInfo != null) {
            LOG.debug("Checking event source health");
            InformerHealthSummary healthSummary = InformerHealthSummary.fromRuntimeInfo(this.runtimeInfo);
            if (!healthSummary.isAnyHealthy()) {
                LOG.error("All informers are unhealthy");
                return false;
            }
            if (this.anyInformerBecameUnhealthy(healthSummary.getUnhealthyInformers())) {
                return false;
            }
            this.previousInformerHealthSummary = healthSummary;
            if (!this.runtimeInfo.isStarted()) {
                LOG.error("Operator is not running");
                return false;
            }
        }
        for (CanaryResourceManager<?> canaryResourceManager : this.canaryResourceManagers) {
            if (canaryResourceManager.allCanariesHealthy()) continue;
            LOG.error("Unhealthy canary resources");
            return false;
        }
        return true;
    }

    private boolean anyInformerBecameUnhealthy(Set<InformerIdentifier> unhealthyInformers) {
        boolean unhealthy = false;
        for (InformerIdentifier unhealthyInformer : unhealthyInformers) {
            if (this.previousInformerHealthSummary.getUnhealthyInformers().contains(unhealthyInformer)) continue;
            LOG.error("Informer became unhealthy: {}", (Object)unhealthyInformer);
            unhealthy = true;
        }
        return unhealthy;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    static {
        LOG = LoggerFactory.getLogger(HealthProbe.class);
    }
}

