/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkStateSnapshotSpec;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.apache.flink.kubernetes.operator.controller.FlinkStateSnapshotContext;
import org.apache.flink.kubernetes.operator.metrics.MetricManager;
import org.apache.flink.kubernetes.operator.observer.snapshot.StateSnapshotObserver;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.reconciler.snapshot.StateSnapshotReconciler;
import org.apache.flink.kubernetes.operator.service.FlinkResourceContextFactory;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.EventSourceUtils;
import org.apache.flink.kubernetes.operator.utils.FlinkStateSnapshotUtils;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class FlinkStateSnapshotController
implements Reconciler<FlinkStateSnapshot>,
ErrorStatusHandler<FlinkStateSnapshot>,
EventSourceInitializer<FlinkStateSnapshot>,
Cleaner<FlinkStateSnapshot> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkStateSnapshotController.class);
    private final Set<FlinkResourceValidator> validators;
    private final FlinkResourceContextFactory ctxFactory;
    private final StateSnapshotReconciler reconciler;
    private final StateSnapshotObserver observer;
    private final EventRecorder eventRecorder;
    private final MetricManager<FlinkStateSnapshot> metricManager;
    private final StatusRecorder<FlinkStateSnapshot, FlinkStateSnapshotStatus> statusRecorder;

    public UpdateControl<FlinkStateSnapshot> reconcile(FlinkStateSnapshot flinkStateSnapshot, Context<FlinkStateSnapshot> josdkContext) {
        flinkStateSnapshot.setStatus((Object)Objects.requireNonNullElseGet((FlinkStateSnapshotStatus)flinkStateSnapshot.getStatus(), FlinkStateSnapshotStatus::new));
        FlinkStateSnapshotContext ctx = this.ctxFactory.getFlinkStateSnapshotContext(flinkStateSnapshot, josdkContext);
        this.observer.observe(ctx);
        if (this.validateSnapshot(ctx)) {
            this.reconciler.reconcile(ctx);
        }
        this.updateLabels(ctx);
        this.notifyListenersAndMetricManager(ctx);
        return this.getUpdateControl(ctx);
    }

    public DeleteControl cleanup(FlinkStateSnapshot flinkStateSnapshot, Context<FlinkStateSnapshot> josdkContext) {
        FlinkStateSnapshotContext ctx = this.ctxFactory.getFlinkStateSnapshotContext(flinkStateSnapshot, josdkContext);
        try {
            this.metricManager.onRemove(flinkStateSnapshot);
            return this.reconciler.cleanup(ctx);
        }
        catch (Exception e) {
            this.eventRecorder.triggerSnapshotEvent(flinkStateSnapshot, EventRecorder.Type.Warning, EventRecorder.Reason.CleanupFailed, EventRecorder.Component.Snapshot, e.getMessage(), ctx.getKubernetesClient());
            LOG.error("Error during cleanup of snapshot {}", (Object)flinkStateSnapshot.getMetadata().getName(), (Object)e);
            return DeleteControl.noFinalizerRemoval().rescheduleAfter(ctx.getOperatorConfig().getReconcileInterval().toMillis());
        }
    }

    public ErrorStatusUpdateControl<FlinkStateSnapshot> updateErrorStatus(FlinkStateSnapshot resource, Context<FlinkStateSnapshot> context, Exception e) {
        FlinkStateSnapshotContext ctx = this.ctxFactory.getFlinkStateSnapshotContext(resource, context);
        ReconciliationUtils.updateForReconciliationError(ctx, (Throwable)e);
        EventRecorder.Reason reason = ((FlinkStateSnapshotSpec)resource.getSpec()).isSavepoint() ? EventRecorder.Reason.SavepointError : EventRecorder.Reason.CheckpointError;
        this.eventRecorder.triggerSnapshotEvent(resource, EventRecorder.Type.Warning, reason, EventRecorder.Component.Snapshot, ((FlinkStateSnapshotStatus)resource.getStatus()).getError(), ctx.getKubernetesClient());
        if (((FlinkStateSnapshotStatus)resource.getStatus()).getFailures() > ((FlinkStateSnapshotSpec)resource.getSpec()).getBackoffLimit()) {
            LOG.info("Snapshot {} failed and won't be retried as failure count exceeded the backoff limit", (Object)resource.getMetadata().getName());
            this.notifyListenersAndMetricManager(ctx);
            return ErrorStatusUpdateControl.patchStatus((HasMetadata)resource).withNoRetry();
        }
        long retrySeconds = 10L * (1L << ((FlinkStateSnapshotStatus)resource.getStatus()).getFailures() - 1);
        LOG.info("Snapshot {} failed and will be retried in {} seconds...", (Object)resource.getMetadata().getName(), (Object)retrySeconds);
        FlinkStateSnapshotUtils.snapshotTriggerPending(resource);
        this.notifyListenersAndMetricManager(ctx);
        return ErrorStatusUpdateControl.patchStatus((HasMetadata)resource).rescheduleAfter(Duration.ofSeconds(retrySeconds));
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<FlinkStateSnapshot> context) {
        return EventSourceInitializer.nameEventSources((EventSource[])EventSourceUtils.getFlinkStateSnapshotInformerEventSources(context));
    }

    private UpdateControl<FlinkStateSnapshot> getUpdateControl(FlinkStateSnapshotContext ctx) {
        FlinkStateSnapshot resource = ctx.getResource();
        UpdateControl updateControl = UpdateControl.noUpdate();
        boolean labelsChanged = this.resourceLabelsChanged(ctx);
        boolean statusChanged = this.resourceStatusChanged(ctx);
        if (labelsChanged && statusChanged) {
            updateControl = UpdateControl.updateResourceAndPatchStatus((HasMetadata)resource);
        } else if (labelsChanged) {
            updateControl = UpdateControl.updateResource((HasMetadata)resource);
        } else if (statusChanged) {
            updateControl = UpdateControl.patchStatus((HasMetadata)resource);
        }
        switch (((FlinkStateSnapshotStatus)resource.getStatus()).getState()) {
            case COMPLETED: 
            case ABANDONED: {
                return updateControl;
            }
        }
        return (UpdateControl)updateControl.rescheduleAfter(ctx.getOperatorConfig().getReconcileInterval().toMillis());
    }

    private void notifyListenersAndMetricManager(FlinkStateSnapshotContext ctx) {
        if (this.resourceStatusChanged(ctx)) {
            this.statusRecorder.notifyListeners(ctx.getResource(), ctx.getOriginalStatus());
        }
        this.metricManager.onUpdate(ctx.getResource());
    }

    private boolean validateSnapshot(FlinkStateSnapshotContext ctx) {
        FlinkStateSnapshot savepoint = ctx.getResource();
        for (FlinkResourceValidator validator : this.validators) {
            Optional<String> validationError = validator.validateStateSnapshot(savepoint, ctx.getSecondaryResource());
            if (!validationError.isPresent()) continue;
            this.eventRecorder.triggerSnapshotEvent(savepoint, EventRecorder.Type.Warning, EventRecorder.Reason.ValidationError, EventRecorder.Component.Operator, validationError.get(), ctx.getKubernetesClient());
            return false;
        }
        return true;
    }

    private void updateLabels(FlinkStateSnapshotContext ctx) {
        HashMap<String, String> labels = new HashMap<String, String>(ctx.getResource().getMetadata().getLabels());
        labels.putAll(FlinkStateSnapshotUtils.getSnapshotLabels(ctx.getResource(), ctx.getSecondaryResource()));
        ctx.getResource().getMetadata().setLabels(labels);
    }

    private boolean resourceStatusChanged(FlinkStateSnapshotContext ctx) {
        return !ctx.getOriginalStatus().equals(ctx.getResource().getStatus());
    }

    private boolean resourceLabelsChanged(FlinkStateSnapshotContext ctx) {
        return !ctx.getOriginalLabels().equals(ctx.getResource().getMetadata().getLabels());
    }

    public FlinkStateSnapshotController(Set<FlinkResourceValidator> validators, FlinkResourceContextFactory ctxFactory, StateSnapshotReconciler reconciler, StateSnapshotObserver observer, EventRecorder eventRecorder, MetricManager<FlinkStateSnapshot> metricManager, StatusRecorder<FlinkStateSnapshot, FlinkStateSnapshotStatus> statusRecorder) {
        this.validators = validators;
        this.ctxFactory = ctxFactory;
        this.reconciler = reconciler;
        this.observer = observer;
        this.eventRecorder = eventRecorder;
        this.metricManager = metricManager;
        this.statusRecorder = statusRecorder;
    }
}

