/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.spec.FlinkStateSnapshotSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobKind;
import org.apache.flink.kubernetes.operator.api.spec.JobReference;
import org.apache.flink.kubernetes.operator.api.status.FlinkStateSnapshotStatus;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;

public class FlinkStateSnapshotContext {
    private final FlinkStateSnapshot resource;
    private final FlinkStateSnapshotStatus originalStatus;
    private final Map<String, String> originalLabels;
    private final Context<FlinkStateSnapshot> josdkContext;
    private final FlinkConfigManager configManager;
    private final AtomicReference<Object> operatorConfig = new AtomicReference();
    private final AtomicReference<Object> referencedJobObserveConfig = new AtomicReference();
    private final AtomicReference<Object> referencedJobFlinkDeployment = new AtomicReference();

    private FlinkOperatorConfiguration operatorConfig() {
        return this.getConfigManager().getOperatorConfiguration(this.getResource().getMetadata().getNamespace(), null);
    }

    private Configuration referencedJobObserveConfig() {
        return this.getConfigManager().getObserveConfig(this.getReferencedJobFlinkDeployment());
    }

    private FlinkDeployment referencedJobFlinkDeployment() {
        return (FlinkDeployment)this.getJosdkContext().getSecondaryResource(FlinkDeployment.class).orElseThrow(() -> new RuntimeException(String.format("Failed to find FlinkDeployment from job reference: %s", ((FlinkStateSnapshotSpec)this.getResource().getSpec()).getJobReference().getName())));
    }

    public Optional<AbstractFlinkResource<?, ?>> getSecondaryResource() {
        JobKind jobKind = Optional.ofNullable(((FlinkStateSnapshotSpec)this.getResource().getSpec()).getJobReference()).map(JobReference::getKind).orElse(null);
        if (JobKind.FLINK_DEPLOYMENT.equals((Object)jobKind)) {
            return this.getJosdkContext().getSecondaryResource(FlinkDeployment.class).map(r -> r);
        }
        if (JobKind.FLINK_SESSION_JOB.equals((Object)jobKind)) {
            return this.getJosdkContext().getSecondaryResource(FlinkSessionJob.class).map(r -> r);
        }
        return Optional.empty();
    }

    public KubernetesClient getKubernetesClient() {
        return this.getJosdkContext().getClient();
    }

    public FlinkStateSnapshot getResource() {
        return this.resource;
    }

    public FlinkStateSnapshotStatus getOriginalStatus() {
        return this.originalStatus;
    }

    public Map<String, String> getOriginalLabels() {
        return this.originalLabels;
    }

    public Context<FlinkStateSnapshot> getJosdkContext() {
        return this.josdkContext;
    }

    public FlinkConfigManager getConfigManager() {
        return this.configManager;
    }

    public FlinkStateSnapshotContext(FlinkStateSnapshot resource, FlinkStateSnapshotStatus originalStatus, Map<String, String> originalLabels, Context<FlinkStateSnapshot> josdkContext, FlinkConfigManager configManager) {
        this.resource = resource;
        this.originalStatus = originalStatus;
        this.originalLabels = originalLabels;
        this.josdkContext = josdkContext;
        this.configManager = configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlinkOperatorConfiguration getOperatorConfig() {
        Object value = this.operatorConfig.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.operatorConfig;
            synchronized (atomicReference) {
                value = this.operatorConfig.get();
                if (value == null) {
                    FlinkOperatorConfiguration actualValue = this.operatorConfig();
                    value = actualValue == null ? this.operatorConfig : actualValue;
                    this.operatorConfig.set(value);
                }
            }
        }
        return (FlinkOperatorConfiguration)(value == this.operatorConfig ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getReferencedJobObserveConfig() {
        Object value = this.referencedJobObserveConfig.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.referencedJobObserveConfig;
            synchronized (atomicReference) {
                value = this.referencedJobObserveConfig.get();
                if (value == null) {
                    Configuration actualValue = this.referencedJobObserveConfig();
                    value = actualValue == null ? this.referencedJobObserveConfig : actualValue;
                    this.referencedJobObserveConfig.set(value);
                }
            }
        }
        return (Configuration)(value == this.referencedJobObserveConfig ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlinkDeployment getReferencedJobFlinkDeployment() {
        Object value = this.referencedJobFlinkDeployment.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.referencedJobFlinkDeployment;
            synchronized (atomicReference) {
                value = this.referencedJobFlinkDeployment.get();
                if (value == null) {
                    FlinkDeployment actualValue = this.referencedJobFlinkDeployment();
                    value = actualValue == null ? this.referencedJobFlinkDeployment : actualValue;
                    this.referencedJobFlinkDeployment.set(value);
                }
            }
        }
        return (FlinkDeployment)(value == this.referencedJobFlinkDeployment ? null : value);
    }
}

