/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusHandler;
import io.javaoperatorsdk.operator.api.reconciler.ErrorStatusUpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.FlinkStateSnapshot;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.api.status.FlinkSessionJobStatus;
import org.apache.flink.kubernetes.operator.controller.FlinkResourceContext;
import org.apache.flink.kubernetes.operator.exception.ReconciliationException;
import org.apache.flink.kubernetes.operator.health.CanaryResourceManager;
import org.apache.flink.kubernetes.operator.observer.Observer;
import org.apache.flink.kubernetes.operator.reconciler.Reconciler;
import org.apache.flink.kubernetes.operator.reconciler.ReconciliationUtils;
import org.apache.flink.kubernetes.operator.service.FlinkResourceContextFactory;
import org.apache.flink.kubernetes.operator.utils.EventRecorder;
import org.apache.flink.kubernetes.operator.utils.EventSourceUtils;
import org.apache.flink.kubernetes.operator.utils.KubernetesClientUtils;
import org.apache.flink.kubernetes.operator.utils.StatusRecorder;
import org.apache.flink.kubernetes.operator.utils.ValidatorUtils;
import org.apache.flink.kubernetes.operator.validation.FlinkResourceValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ControllerConfiguration
public class FlinkSessionJobController
implements io.javaoperatorsdk.operator.api.reconciler.Reconciler<FlinkSessionJob>,
ErrorStatusHandler<FlinkSessionJob>,
EventSourceInitializer<FlinkSessionJob>,
Cleaner<FlinkSessionJob> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkSessionJobController.class);
    private final Set<FlinkResourceValidator> validators;
    private final FlinkResourceContextFactory ctxFactory;
    private final Reconciler<FlinkSessionJob> reconciler;
    private final Observer<FlinkSessionJob> observer;
    private final StatusRecorder<FlinkSessionJob, FlinkSessionJobStatus> statusRecorder;
    private final EventRecorder eventRecorder;
    private final CanaryResourceManager<FlinkSessionJob> canaryResourceManager;

    public FlinkSessionJobController(Set<FlinkResourceValidator> validators, FlinkResourceContextFactory ctxFactory, Reconciler<FlinkSessionJob> reconciler, Observer<FlinkSessionJob> observer, StatusRecorder<FlinkSessionJob, FlinkSessionJobStatus> statusRecorder, EventRecorder eventRecorder, CanaryResourceManager<FlinkSessionJob> canaryResourceManager) {
        this.validators = validators;
        this.ctxFactory = ctxFactory;
        this.reconciler = reconciler;
        this.observer = observer;
        this.statusRecorder = statusRecorder;
        this.eventRecorder = eventRecorder;
        this.canaryResourceManager = canaryResourceManager;
    }

    public UpdateControl<FlinkSessionJob> reconcile(FlinkSessionJob flinkSessionJob, Context josdkContext) {
        if (this.canaryResourceManager.handleCanaryResourceReconciliation(flinkSessionJob, josdkContext.getClient())) {
            return UpdateControl.noUpdate();
        }
        LOG.info("Starting reconciliation");
        this.statusRecorder.updateStatusFromCache(flinkSessionJob);
        FlinkSessionJob previousJob = ReconciliationUtils.clone(flinkSessionJob);
        FlinkResourceContext<FlinkSessionJob> ctx = this.ctxFactory.getResourceContext(flinkSessionJob, josdkContext);
        if (!ValidatorUtils.validateSupportedVersion(ctx, this.eventRecorder)) {
            return UpdateControl.noUpdate();
        }
        this.observer.observe(ctx);
        if (!this.validateSessionJob(ctx)) {
            this.statusRecorder.patchAndCacheStatus(flinkSessionJob, ctx.getKubernetesClient());
            return ReconciliationUtils.toUpdateControl(ctx.getOperatorConfig(), flinkSessionJob, previousJob, false);
        }
        try {
            this.statusRecorder.patchAndCacheStatus(flinkSessionJob, ctx.getKubernetesClient());
            this.reconciler.reconcile(ctx);
        }
        catch (Exception e) {
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)flinkSessionJob, EventRecorder.Type.Warning, "SessionJobException", e.getMessage(), EventRecorder.Component.Job, josdkContext.getClient());
            throw new ReconciliationException(e);
        }
        this.statusRecorder.patchAndCacheStatus(flinkSessionJob, ctx.getKubernetesClient());
        return ReconciliationUtils.toUpdateControl(ctx.getOperatorConfig(), flinkSessionJob, previousJob, true);
    }

    public DeleteControl cleanup(FlinkSessionJob sessionJob, Context josdkContext) {
        if (this.canaryResourceManager.handleCanaryResourceDeletion(sessionJob)) {
            return DeleteControl.defaultDelete();
        }
        this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)sessionJob, EventRecorder.Type.Normal, EventRecorder.Reason.Cleanup, EventRecorder.Component.Operator, "Cleaning up FlinkSessionJob", josdkContext.getClient());
        this.statusRecorder.updateStatusFromCache(sessionJob);
        ((FlinkSessionJobStatus)sessionJob.getStatus()).setLifecycleState(ResourceLifecycleState.DELETING);
        FlinkResourceContext<FlinkSessionJob> ctx = this.ctxFactory.getResourceContext(sessionJob, josdkContext);
        try {
            this.observer.observe(ctx);
        }
        catch (Exception err) {
            LOG.error("Error while observing for cleanup", (Throwable)err);
        }
        DeleteControl deleteControl = this.reconciler.cleanup(ctx);
        if (deleteControl.isRemoveFinalizer()) {
            ((FlinkSessionJobStatus)sessionJob.getStatus()).setLifecycleState(ResourceLifecycleState.DELETED);
            this.ctxFactory.cleanup(sessionJob);
            this.statusRecorder.cleanupForDeletion(sessionJob);
        } else {
            this.statusRecorder.patchAndCacheStatus(sessionJob, ctx.getKubernetesClient());
        }
        return deleteControl;
    }

    public ErrorStatusUpdateControl<FlinkSessionJob> updateErrorStatus(FlinkSessionJob sessionJob, Context<FlinkSessionJob> context, Exception e) {
        FlinkResourceContext<FlinkSessionJob> ctx = this.ctxFactory.getResourceContext(sessionJob, context);
        return ReconciliationUtils.toErrorStatusUpdateControl(ctx, e, this.statusRecorder);
    }

    public Map<String, EventSource> prepareEventSources(EventSourceContext<FlinkSessionJob> context) {
        ArrayList<Object> eventSources = new ArrayList<Object>();
        eventSources.add(EventSourceUtils.getFlinkDeploymentInformerEventSource(context));
        if (KubernetesClientUtils.isCrdInstalled(FlinkStateSnapshot.class)) {
            eventSources.add(EventSourceUtils.getStateSnapshotForFlinkResourceInformerEventSource(context));
        } else {
            LOG.warn("Could not initialize informer for snapshots as the CRD has not been installed!");
        }
        return EventSourceInitializer.nameEventSources((EventSource[])((EventSource[])eventSources.toArray(EventSource[]::new)));
    }

    private boolean validateSessionJob(FlinkResourceContext<FlinkSessionJob> ctx) {
        FlinkSessionJob sessionJob = ctx.getResource();
        for (FlinkResourceValidator validator : this.validators) {
            Optional<String> validationError = validator.validateSessionJob(sessionJob, ctx.getJosdkContext().getSecondaryResource(FlinkDeployment.class));
            if (!validationError.isPresent()) continue;
            this.eventRecorder.triggerEvent((AbstractFlinkResource<?, ?>)sessionJob, EventRecorder.Type.Warning, EventRecorder.Reason.ValidationError, EventRecorder.Component.Operator, validationError.get(), ctx.getKubernetesClient());
            return ReconciliationUtils.applyValidationErrorAndResetSpec(ctx, validationError.get());
        }
        return true;
    }
}

