/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.controller;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.autoscaler.config.AutoScalerOptions;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.kubernetes.operator.config.FlinkOperatorConfiguration;
import org.apache.flink.kubernetes.operator.metrics.KubernetesResourceMetricGroup;
import org.apache.flink.kubernetes.operator.service.FlinkService;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.function.SupplierWithException;

public abstract class FlinkResourceContext<CR extends AbstractFlinkResource<?, ?>> {
    private final CR resource;
    private final Context<?> josdkContext;
    private final KubernetesResourceMetricGroup resourceMetricGroup;
    protected final FlinkConfigManager configManager;
    private final Function<FlinkResourceContext<?>, FlinkService> flinkServiceFactory;
    private FlinkOperatorConfiguration operatorConfig;
    private Configuration observeConfig;
    private FlinkService flinkService;
    private KubernetesJobAutoScalerContext autoScalerContext;

    public KubernetesJobAutoScalerContext getJobAutoScalerContext() {
        if (this.autoScalerContext != null) {
            return this.autoScalerContext;
        }
        this.autoScalerContext = this.createJobAutoScalerContext();
        return this.autoScalerContext;
    }

    private KubernetesJobAutoScalerContext createJobAutoScalerContext() {
        Configuration conf = new Configuration(this.getDeployConfig((AbstractFlinkSpec)this.resource.getSpec()));
        conf.set(AutoScalerOptions.FLINK_CLIENT_TIMEOUT, (Object)this.getOperatorConfig().getFlinkClientTimeout());
        CommonStatus status = (CommonStatus)this.getResource().getStatus();
        String jobId = status.getJobStatus().getJobId();
        JobStatus jobStatus = status.getJobStatus().getState();
        return new KubernetesJobAutoScalerContext(jobId == null ? null : JobID.fromHexString((String)jobId), jobStatus, conf, (MetricGroup)this.getResourceMetricGroup(), (SupplierWithException<RestClusterClient<String>, Exception>)((SupplierWithException)() -> this.getFlinkService().getClusterClient(conf)), this);
    }

    @Nullable
    public Configuration getObserveConfig() {
        if (this.observeConfig != null) {
            return this.observeConfig;
        }
        this.observeConfig = this.createObserveConfig();
        return this.observeConfig;
    }

    @Nullable
    public abstract Configuration getDeployConfig(AbstractFlinkSpec var1);

    public FlinkService getFlinkService() {
        if (this.flinkService != null) {
            return this.flinkService;
        }
        this.flinkService = this.createFlinkService();
        return this.flinkService;
    }

    protected FlinkService createFlinkService() {
        return this.flinkServiceFactory.apply(this);
    }

    protected abstract Configuration createObserveConfig();

    public abstract KubernetesDeploymentMode getDeploymentMode();

    public abstract FlinkVersion getFlinkVersion();

    public FlinkOperatorConfiguration getOperatorConfig() {
        if (this.operatorConfig != null) {
            return this.operatorConfig;
        }
        this.operatorConfig = this.configManager.getOperatorConfiguration(this.getResource().getMetadata().getNamespace(), this.getFlinkVersion());
        return this.operatorConfig;
    }

    public KubernetesClient getKubernetesClient() {
        return this.getJosdkContext().getClient();
    }

    public FlinkResourceContext(CR resource, Context<?> josdkContext, KubernetesResourceMetricGroup resourceMetricGroup, FlinkConfigManager configManager, Function<FlinkResourceContext<?>, FlinkService> flinkServiceFactory) {
        this.resource = resource;
        this.josdkContext = josdkContext;
        this.resourceMetricGroup = resourceMetricGroup;
        this.configManager = configManager;
        this.flinkServiceFactory = flinkServiceFactory;
    }

    public CR getResource() {
        return this.resource;
    }

    public Context<?> getJosdkContext() {
        return this.josdkContext;
    }

    public KubernetesResourceMetricGroup getResourceMetricGroup() {
        return this.resourceMetricGroup;
    }
}

