/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.config;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.kubernetes.operator.config.KubernetesOperatorConfigOptions;
import org.apache.flink.kubernetes.operator.metrics.KubernetesOperatorMetricOptions;
import org.apache.flink.kubernetes.operator.utils.EnvUtils;

public final class FlinkOperatorConfiguration {
    private static final String NAMESPACES_SPLITTER_KEY = "\\s*,\\s*";
    private static final String ENV_KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private final Duration reconcileInterval;
    private final int reconcilerMaxParallelism;
    private final Duration progressCheckInterval;
    private final Duration restApiReadyDelay;
    private final Duration flinkClientTimeout;
    private final String flinkServiceHostOverride;
    private final Set<String> watchedNamespaces;
    private final boolean dynamicNamespacesEnabled;
    private final boolean josdkMetricsEnabled;
    private final int metricsHistogramSampleSize;
    private final boolean kubernetesClientMetricsEnabled;
    private final boolean kubernetesClientMetricsHttpResponseCodeGroupsEnabled;
    private final Duration flinkCancelJobTimeout;
    private final Duration flinkShutdownClusterTimeout;
    private final String artifactsBaseDir;
    private final Integer savepointHistoryCountThreshold;
    private final Duration savepointHistoryAgeThreshold;
    private final GenericRetry retryConfiguration;
    private final RateLimiter<?> rateLimiter;
    private final boolean exceptionStackTraceEnabled;
    private final int exceptionStackTraceLengthThreshold;
    private final int exceptionFieldLengthThreshold;
    private final int exceptionThrowableCountThreshold;
    private final Map<String, String> exceptionLabelMapper;
    private final String labelSelector;
    private final LeaderElectionConfiguration leaderElectionConfiguration;
    private final DeletionPropagation deletionPropagation;
    private final boolean snapshotResourcesEnabled;
    private final Duration slowRequestThreshold;

    public static FlinkOperatorConfiguration fromConfiguration(Configuration operatorConfig) {
        Duration reconcileInterval = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_RECONCILE_INTERVAL);
        int reconcilerMaxParallelism = operatorConfig.getInteger(KubernetesOperatorConfigOptions.OPERATOR_RECONCILE_PARALLELISM);
        Duration restApiReadyDelay = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_OBSERVER_REST_READY_DELAY);
        Duration progressCheckInterval = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_OBSERVER_PROGRESS_CHECK_INTERVAL);
        Duration flinkClientTimeout = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_FLINK_CLIENT_TIMEOUT);
        Duration flinkCancelJobTimeout = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_FLINK_CLIENT_CANCEL_TIMEOUT);
        Duration flinkShutdownClusterTimeout = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_RESOURCE_CLEANUP_TIMEOUT);
        String artifactsBaseDir = (String)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_USER_ARTIFACTS_BASE_DIR);
        Integer savepointHistoryCountThreshold = (Integer)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_HISTORY_MAX_COUNT_THRESHOLD);
        Duration savepointHistoryAgeThreshold = (Duration)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_SAVEPOINT_HISTORY_MAX_AGE_THRESHOLD);
        Boolean exceptionStackTraceEnabled = (Boolean)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_EXCEPTION_STACK_TRACE_ENABLED);
        int exceptionStackTraceLengthThreshold = (Integer)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_EXCEPTION_STACK_TRACE_MAX_LENGTH);
        int exceptionFieldLengthThreshold = (Integer)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_EXCEPTION_FIELD_MAX_LENGTH);
        int exceptionThrowableCountThreshold = (Integer)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_EXCEPTION_THROWABLE_LIST_MAX_COUNT);
        Map exceptionLabelMapper = (Map)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_EXCEPTION_LABEL_MAPPER);
        String flinkServiceHostOverride = null;
        if (FlinkOperatorConfiguration.getEnv(ENV_KUBERNETES_SERVICE_HOST).isEmpty()) {
            flinkServiceHostOverride = "localhost";
        }
        HashSet<String> watchedNamespaces = null;
        watchedNamespaces = EnvUtils.get("WATCH_NAMESPACES").isEmpty() ? new HashSet<String>(Arrays.asList(((String)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_WATCHED_NAMESPACES)).split(NAMESPACES_SPLITTER_KEY))) : new HashSet<String>(Arrays.asList(EnvUtils.get("WATCH_NAMESPACES").get().split(NAMESPACES_SPLITTER_KEY)));
        boolean dynamicNamespacesEnabled = (Boolean)operatorConfig.get(KubernetesOperatorConfigOptions.OPERATOR_DYNAMIC_NAMESPACES_ENABLED);
        boolean josdkMetricsEnabled = (Boolean)operatorConfig.get(KubernetesOperatorMetricOptions.OPERATOR_JOSDK_METRICS_ENABLED);
        boolean kubernetesClientMetricsEnabled = (Boolean)operatorConfig.get(KubernetesOperatorMetricOptions.OPERATOR_KUBERNETES_CLIENT_METRICS_ENABLED);
        boolean kubernetesClientMetricsHttpResponseCodeGroupsEnabled = (Boolean)operatorConfig.get(KubernetesOperatorMetricOptions.OPERATOR_KUBERNETES_CLIENT_METRICS_HTTP_RESPONSE_CODE_GROUPS_ENABLED);
        int metricsHistogramSampleSize = (Integer)operatorConfig.get(KubernetesOperatorMetricOptions.OPERATOR_METRICS_HISTOGRAM_SAMPLE_SIZE);
        GenericRetry retryConfiguration = FlinkOperatorConfiguration.getRetryConfig(operatorConfig);
        RateLimiter<?> rateLimiter = FlinkOperatorConfiguration.getRateLimiter(operatorConfig);
        String labelSelector = operatorConfig.getString(KubernetesOperatorConfigOptions.OPERATOR_LABEL_SELECTOR);
        DeletionPropagation deletionPropagation = (DeletionPropagation)operatorConfig.get(KubernetesOperatorConfigOptions.RESOURCE_DELETION_PROPAGATION);
        boolean snapshotResourcesEnabled = (Boolean)operatorConfig.get(KubernetesOperatorConfigOptions.SNAPSHOT_RESOURCE_ENABLED);
        Duration slowRequestThreshold = (Duration)operatorConfig.get(KubernetesOperatorMetricOptions.OPERATOR_KUBERNETES_SLOW_REQUEST_THRESHOLD);
        return new FlinkOperatorConfiguration(reconcileInterval, reconcilerMaxParallelism, progressCheckInterval, restApiReadyDelay, flinkClientTimeout, flinkServiceHostOverride, watchedNamespaces, dynamicNamespacesEnabled, josdkMetricsEnabled, metricsHistogramSampleSize, kubernetesClientMetricsEnabled, kubernetesClientMetricsHttpResponseCodeGroupsEnabled, flinkCancelJobTimeout, flinkShutdownClusterTimeout, artifactsBaseDir, savepointHistoryCountThreshold, savepointHistoryAgeThreshold, retryConfiguration, rateLimiter, exceptionStackTraceEnabled, exceptionStackTraceLengthThreshold, exceptionFieldLengthThreshold, exceptionThrowableCountThreshold, exceptionLabelMapper, labelSelector, FlinkOperatorConfiguration.getLeaderElectionConfig(operatorConfig), deletionPropagation, snapshotResourcesEnabled, slowRequestThreshold);
    }

    private static GenericRetry getRetryConfig(Configuration conf) {
        GenericRetry genericRetry = new GenericRetry().setMaxAttempts(conf.getInteger(KubernetesOperatorConfigOptions.OPERATOR_RETRY_MAX_ATTEMPTS)).setInitialInterval(((Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_RETRY_INITIAL_INTERVAL)).toMillis()).setIntervalMultiplier(conf.getDouble(KubernetesOperatorConfigOptions.OPERATOR_RETRY_INTERVAL_MULTIPLIER));
        if (conf.contains(KubernetesOperatorConfigOptions.OPERATOR_RETRY_MAX_INTERVAL)) {
            genericRetry.setMaxInterval(((Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_RETRY_MAX_INTERVAL)).toMillis());
        } else {
            genericRetry.withoutMaxInterval();
        }
        return genericRetry;
    }

    private static RateLimiter<?> getRateLimiter(Configuration conf) {
        return new LinearRateLimiter((Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_RATE_LIMITER_PERIOD), ((Integer)conf.get(KubernetesOperatorConfigOptions.OPERATOR_RATE_LIMITER_LIMIT)).intValue());
    }

    private static LeaderElectionConfiguration getLeaderElectionConfig(Configuration conf) {
        if (!((Boolean)conf.get(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_ENABLED)).booleanValue()) {
            return null;
        }
        return new LeaderElectionConfiguration((String)conf.getOptional(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_LEASE_NAME).orElseThrow(() -> new IllegalConfigurationException(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_LEASE_NAME.key() + " must be defined when operator leader election is enabled.")), null, (Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_LEASE_DURATION), (Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_RENEW_DEADLINE), (Duration)conf.get(KubernetesOperatorConfigOptions.OPERATOR_LEADER_ELECTION_RETRY_PERIOD));
    }

    private static Optional<String> getEnv(String key) {
        return Optional.ofNullable((String)StringUtils.getIfBlank((CharSequence)System.getenv().get(key), () -> null));
    }

    public FlinkOperatorConfiguration(Duration reconcileInterval, int reconcilerMaxParallelism, Duration progressCheckInterval, Duration restApiReadyDelay, Duration flinkClientTimeout, String flinkServiceHostOverride, Set<String> watchedNamespaces, boolean dynamicNamespacesEnabled, boolean josdkMetricsEnabled, int metricsHistogramSampleSize, boolean kubernetesClientMetricsEnabled, boolean kubernetesClientMetricsHttpResponseCodeGroupsEnabled, Duration flinkCancelJobTimeout, Duration flinkShutdownClusterTimeout, String artifactsBaseDir, Integer savepointHistoryCountThreshold, Duration savepointHistoryAgeThreshold, GenericRetry retryConfiguration, RateLimiter<?> rateLimiter, boolean exceptionStackTraceEnabled, int exceptionStackTraceLengthThreshold, int exceptionFieldLengthThreshold, int exceptionThrowableCountThreshold, Map<String, String> exceptionLabelMapper, String labelSelector, LeaderElectionConfiguration leaderElectionConfiguration, DeletionPropagation deletionPropagation, boolean snapshotResourcesEnabled, Duration slowRequestThreshold) {
        this.reconcileInterval = reconcileInterval;
        this.reconcilerMaxParallelism = reconcilerMaxParallelism;
        this.progressCheckInterval = progressCheckInterval;
        this.restApiReadyDelay = restApiReadyDelay;
        this.flinkClientTimeout = flinkClientTimeout;
        this.flinkServiceHostOverride = flinkServiceHostOverride;
        this.watchedNamespaces = watchedNamespaces;
        this.dynamicNamespacesEnabled = dynamicNamespacesEnabled;
        this.josdkMetricsEnabled = josdkMetricsEnabled;
        this.metricsHistogramSampleSize = metricsHistogramSampleSize;
        this.kubernetesClientMetricsEnabled = kubernetesClientMetricsEnabled;
        this.kubernetesClientMetricsHttpResponseCodeGroupsEnabled = kubernetesClientMetricsHttpResponseCodeGroupsEnabled;
        this.flinkCancelJobTimeout = flinkCancelJobTimeout;
        this.flinkShutdownClusterTimeout = flinkShutdownClusterTimeout;
        this.artifactsBaseDir = artifactsBaseDir;
        this.savepointHistoryCountThreshold = savepointHistoryCountThreshold;
        this.savepointHistoryAgeThreshold = savepointHistoryAgeThreshold;
        this.retryConfiguration = retryConfiguration;
        this.rateLimiter = rateLimiter;
        this.exceptionStackTraceEnabled = exceptionStackTraceEnabled;
        this.exceptionStackTraceLengthThreshold = exceptionStackTraceLengthThreshold;
        this.exceptionFieldLengthThreshold = exceptionFieldLengthThreshold;
        this.exceptionThrowableCountThreshold = exceptionThrowableCountThreshold;
        this.exceptionLabelMapper = exceptionLabelMapper;
        this.labelSelector = labelSelector;
        this.leaderElectionConfiguration = leaderElectionConfiguration;
        this.deletionPropagation = deletionPropagation;
        this.snapshotResourcesEnabled = snapshotResourcesEnabled;
        this.slowRequestThreshold = slowRequestThreshold;
    }

    public Duration getReconcileInterval() {
        return this.reconcileInterval;
    }

    public int getReconcilerMaxParallelism() {
        return this.reconcilerMaxParallelism;
    }

    public Duration getProgressCheckInterval() {
        return this.progressCheckInterval;
    }

    public Duration getRestApiReadyDelay() {
        return this.restApiReadyDelay;
    }

    public Duration getFlinkClientTimeout() {
        return this.flinkClientTimeout;
    }

    public String getFlinkServiceHostOverride() {
        return this.flinkServiceHostOverride;
    }

    public Set<String> getWatchedNamespaces() {
        return this.watchedNamespaces;
    }

    public boolean isDynamicNamespacesEnabled() {
        return this.dynamicNamespacesEnabled;
    }

    public boolean isJosdkMetricsEnabled() {
        return this.josdkMetricsEnabled;
    }

    public int getMetricsHistogramSampleSize() {
        return this.metricsHistogramSampleSize;
    }

    public boolean isKubernetesClientMetricsEnabled() {
        return this.kubernetesClientMetricsEnabled;
    }

    public boolean isKubernetesClientMetricsHttpResponseCodeGroupsEnabled() {
        return this.kubernetesClientMetricsHttpResponseCodeGroupsEnabled;
    }

    public Duration getFlinkCancelJobTimeout() {
        return this.flinkCancelJobTimeout;
    }

    public Duration getFlinkShutdownClusterTimeout() {
        return this.flinkShutdownClusterTimeout;
    }

    public String getArtifactsBaseDir() {
        return this.artifactsBaseDir;
    }

    public Integer getSavepointHistoryCountThreshold() {
        return this.savepointHistoryCountThreshold;
    }

    public Duration getSavepointHistoryAgeThreshold() {
        return this.savepointHistoryAgeThreshold;
    }

    public GenericRetry getRetryConfiguration() {
        return this.retryConfiguration;
    }

    public RateLimiter<?> getRateLimiter() {
        return this.rateLimiter;
    }

    public boolean isExceptionStackTraceEnabled() {
        return this.exceptionStackTraceEnabled;
    }

    public int getExceptionStackTraceLengthThreshold() {
        return this.exceptionStackTraceLengthThreshold;
    }

    public int getExceptionFieldLengthThreshold() {
        return this.exceptionFieldLengthThreshold;
    }

    public int getExceptionThrowableCountThreshold() {
        return this.exceptionThrowableCountThreshold;
    }

    public Map<String, String> getExceptionLabelMapper() {
        return this.exceptionLabelMapper;
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public LeaderElectionConfiguration getLeaderElectionConfiguration() {
        return this.leaderElectionConfiguration;
    }

    public DeletionPropagation getDeletionPropagation() {
        return this.deletionPropagation;
    }

    public boolean isSnapshotResourcesEnabled() {
        return this.snapshotResourcesEnabled;
    }

    public Duration getSlowRequestThreshold() {
        return this.slowRequestThreshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkOperatorConfiguration)) {
            return false;
        }
        FlinkOperatorConfiguration other = (FlinkOperatorConfiguration)o;
        if (this.getReconcilerMaxParallelism() != other.getReconcilerMaxParallelism()) {
            return false;
        }
        if (this.isDynamicNamespacesEnabled() != other.isDynamicNamespacesEnabled()) {
            return false;
        }
        if (this.isJosdkMetricsEnabled() != other.isJosdkMetricsEnabled()) {
            return false;
        }
        if (this.getMetricsHistogramSampleSize() != other.getMetricsHistogramSampleSize()) {
            return false;
        }
        if (this.isKubernetesClientMetricsEnabled() != other.isKubernetesClientMetricsEnabled()) {
            return false;
        }
        if (this.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled() != other.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled()) {
            return false;
        }
        if (this.isExceptionStackTraceEnabled() != other.isExceptionStackTraceEnabled()) {
            return false;
        }
        if (this.getExceptionStackTraceLengthThreshold() != other.getExceptionStackTraceLengthThreshold()) {
            return false;
        }
        if (this.getExceptionFieldLengthThreshold() != other.getExceptionFieldLengthThreshold()) {
            return false;
        }
        if (this.getExceptionThrowableCountThreshold() != other.getExceptionThrowableCountThreshold()) {
            return false;
        }
        if (this.isSnapshotResourcesEnabled() != other.isSnapshotResourcesEnabled()) {
            return false;
        }
        Integer this$savepointHistoryCountThreshold = this.getSavepointHistoryCountThreshold();
        Integer other$savepointHistoryCountThreshold = other.getSavepointHistoryCountThreshold();
        if (this$savepointHistoryCountThreshold == null ? other$savepointHistoryCountThreshold != null : !((Object)this$savepointHistoryCountThreshold).equals(other$savepointHistoryCountThreshold)) {
            return false;
        }
        Duration this$reconcileInterval = this.getReconcileInterval();
        Duration other$reconcileInterval = other.getReconcileInterval();
        if (this$reconcileInterval == null ? other$reconcileInterval != null : !((Object)this$reconcileInterval).equals(other$reconcileInterval)) {
            return false;
        }
        Duration this$progressCheckInterval = this.getProgressCheckInterval();
        Duration other$progressCheckInterval = other.getProgressCheckInterval();
        if (this$progressCheckInterval == null ? other$progressCheckInterval != null : !((Object)this$progressCheckInterval).equals(other$progressCheckInterval)) {
            return false;
        }
        Duration this$restApiReadyDelay = this.getRestApiReadyDelay();
        Duration other$restApiReadyDelay = other.getRestApiReadyDelay();
        if (this$restApiReadyDelay == null ? other$restApiReadyDelay != null : !((Object)this$restApiReadyDelay).equals(other$restApiReadyDelay)) {
            return false;
        }
        Duration this$flinkClientTimeout = this.getFlinkClientTimeout();
        Duration other$flinkClientTimeout = other.getFlinkClientTimeout();
        if (this$flinkClientTimeout == null ? other$flinkClientTimeout != null : !((Object)this$flinkClientTimeout).equals(other$flinkClientTimeout)) {
            return false;
        }
        String this$flinkServiceHostOverride = this.getFlinkServiceHostOverride();
        String other$flinkServiceHostOverride = other.getFlinkServiceHostOverride();
        if (this$flinkServiceHostOverride == null ? other$flinkServiceHostOverride != null : !this$flinkServiceHostOverride.equals(other$flinkServiceHostOverride)) {
            return false;
        }
        Set<String> this$watchedNamespaces = this.getWatchedNamespaces();
        Set<String> other$watchedNamespaces = other.getWatchedNamespaces();
        if (this$watchedNamespaces == null ? other$watchedNamespaces != null : !((Object)this$watchedNamespaces).equals(other$watchedNamespaces)) {
            return false;
        }
        Duration this$flinkCancelJobTimeout = this.getFlinkCancelJobTimeout();
        Duration other$flinkCancelJobTimeout = other.getFlinkCancelJobTimeout();
        if (this$flinkCancelJobTimeout == null ? other$flinkCancelJobTimeout != null : !((Object)this$flinkCancelJobTimeout).equals(other$flinkCancelJobTimeout)) {
            return false;
        }
        Duration this$flinkShutdownClusterTimeout = this.getFlinkShutdownClusterTimeout();
        Duration other$flinkShutdownClusterTimeout = other.getFlinkShutdownClusterTimeout();
        if (this$flinkShutdownClusterTimeout == null ? other$flinkShutdownClusterTimeout != null : !((Object)this$flinkShutdownClusterTimeout).equals(other$flinkShutdownClusterTimeout)) {
            return false;
        }
        String this$artifactsBaseDir = this.getArtifactsBaseDir();
        String other$artifactsBaseDir = other.getArtifactsBaseDir();
        if (this$artifactsBaseDir == null ? other$artifactsBaseDir != null : !this$artifactsBaseDir.equals(other$artifactsBaseDir)) {
            return false;
        }
        Duration this$savepointHistoryAgeThreshold = this.getSavepointHistoryAgeThreshold();
        Duration other$savepointHistoryAgeThreshold = other.getSavepointHistoryAgeThreshold();
        if (this$savepointHistoryAgeThreshold == null ? other$savepointHistoryAgeThreshold != null : !((Object)this$savepointHistoryAgeThreshold).equals(other$savepointHistoryAgeThreshold)) {
            return false;
        }
        GenericRetry this$retryConfiguration = this.getRetryConfiguration();
        GenericRetry other$retryConfiguration = other.getRetryConfiguration();
        if (this$retryConfiguration == null ? other$retryConfiguration != null : !this$retryConfiguration.equals(other$retryConfiguration)) {
            return false;
        }
        RateLimiter<?> this$rateLimiter = this.getRateLimiter();
        RateLimiter<?> other$rateLimiter = other.getRateLimiter();
        if (this$rateLimiter == null ? other$rateLimiter != null : !this$rateLimiter.equals(other$rateLimiter)) {
            return false;
        }
        Map<String, String> this$exceptionLabelMapper = this.getExceptionLabelMapper();
        Map<String, String> other$exceptionLabelMapper = other.getExceptionLabelMapper();
        if (this$exceptionLabelMapper == null ? other$exceptionLabelMapper != null : !((Object)this$exceptionLabelMapper).equals(other$exceptionLabelMapper)) {
            return false;
        }
        String this$labelSelector = this.getLabelSelector();
        String other$labelSelector = other.getLabelSelector();
        if (this$labelSelector == null ? other$labelSelector != null : !this$labelSelector.equals(other$labelSelector)) {
            return false;
        }
        LeaderElectionConfiguration this$leaderElectionConfiguration = this.getLeaderElectionConfiguration();
        LeaderElectionConfiguration other$leaderElectionConfiguration = other.getLeaderElectionConfiguration();
        if (this$leaderElectionConfiguration == null ? other$leaderElectionConfiguration != null : !this$leaderElectionConfiguration.equals(other$leaderElectionConfiguration)) {
            return false;
        }
        DeletionPropagation this$deletionPropagation = this.getDeletionPropagation();
        DeletionPropagation other$deletionPropagation = other.getDeletionPropagation();
        if (this$deletionPropagation == null ? other$deletionPropagation != null : !this$deletionPropagation.equals(other$deletionPropagation)) {
            return false;
        }
        Duration this$slowRequestThreshold = this.getSlowRequestThreshold();
        Duration other$slowRequestThreshold = other.getSlowRequestThreshold();
        return !(this$slowRequestThreshold == null ? other$slowRequestThreshold != null : !((Object)this$slowRequestThreshold).equals(other$slowRequestThreshold));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReconcilerMaxParallelism();
        result = result * 59 + (this.isDynamicNamespacesEnabled() ? 79 : 97);
        result = result * 59 + (this.isJosdkMetricsEnabled() ? 79 : 97);
        result = result * 59 + this.getMetricsHistogramSampleSize();
        result = result * 59 + (this.isKubernetesClientMetricsEnabled() ? 79 : 97);
        result = result * 59 + (this.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled() ? 79 : 97);
        result = result * 59 + (this.isExceptionStackTraceEnabled() ? 79 : 97);
        result = result * 59 + this.getExceptionStackTraceLengthThreshold();
        result = result * 59 + this.getExceptionFieldLengthThreshold();
        result = result * 59 + this.getExceptionThrowableCountThreshold();
        result = result * 59 + (this.isSnapshotResourcesEnabled() ? 79 : 97);
        Integer $savepointHistoryCountThreshold = this.getSavepointHistoryCountThreshold();
        result = result * 59 + ($savepointHistoryCountThreshold == null ? 43 : ((Object)$savepointHistoryCountThreshold).hashCode());
        Duration $reconcileInterval = this.getReconcileInterval();
        result = result * 59 + ($reconcileInterval == null ? 43 : ((Object)$reconcileInterval).hashCode());
        Duration $progressCheckInterval = this.getProgressCheckInterval();
        result = result * 59 + ($progressCheckInterval == null ? 43 : ((Object)$progressCheckInterval).hashCode());
        Duration $restApiReadyDelay = this.getRestApiReadyDelay();
        result = result * 59 + ($restApiReadyDelay == null ? 43 : ((Object)$restApiReadyDelay).hashCode());
        Duration $flinkClientTimeout = this.getFlinkClientTimeout();
        result = result * 59 + ($flinkClientTimeout == null ? 43 : ((Object)$flinkClientTimeout).hashCode());
        String $flinkServiceHostOverride = this.getFlinkServiceHostOverride();
        result = result * 59 + ($flinkServiceHostOverride == null ? 43 : $flinkServiceHostOverride.hashCode());
        Set<String> $watchedNamespaces = this.getWatchedNamespaces();
        result = result * 59 + ($watchedNamespaces == null ? 43 : ((Object)$watchedNamespaces).hashCode());
        Duration $flinkCancelJobTimeout = this.getFlinkCancelJobTimeout();
        result = result * 59 + ($flinkCancelJobTimeout == null ? 43 : ((Object)$flinkCancelJobTimeout).hashCode());
        Duration $flinkShutdownClusterTimeout = this.getFlinkShutdownClusterTimeout();
        result = result * 59 + ($flinkShutdownClusterTimeout == null ? 43 : ((Object)$flinkShutdownClusterTimeout).hashCode());
        String $artifactsBaseDir = this.getArtifactsBaseDir();
        result = result * 59 + ($artifactsBaseDir == null ? 43 : $artifactsBaseDir.hashCode());
        Duration $savepointHistoryAgeThreshold = this.getSavepointHistoryAgeThreshold();
        result = result * 59 + ($savepointHistoryAgeThreshold == null ? 43 : ((Object)$savepointHistoryAgeThreshold).hashCode());
        GenericRetry $retryConfiguration = this.getRetryConfiguration();
        result = result * 59 + ($retryConfiguration == null ? 43 : $retryConfiguration.hashCode());
        RateLimiter<?> $rateLimiter = this.getRateLimiter();
        result = result * 59 + ($rateLimiter == null ? 43 : $rateLimiter.hashCode());
        Map<String, String> $exceptionLabelMapper = this.getExceptionLabelMapper();
        result = result * 59 + ($exceptionLabelMapper == null ? 43 : ((Object)$exceptionLabelMapper).hashCode());
        String $labelSelector = this.getLabelSelector();
        result = result * 59 + ($labelSelector == null ? 43 : $labelSelector.hashCode());
        LeaderElectionConfiguration $leaderElectionConfiguration = this.getLeaderElectionConfiguration();
        result = result * 59 + ($leaderElectionConfiguration == null ? 43 : $leaderElectionConfiguration.hashCode());
        DeletionPropagation $deletionPropagation = this.getDeletionPropagation();
        result = result * 59 + ($deletionPropagation == null ? 43 : $deletionPropagation.hashCode());
        Duration $slowRequestThreshold = this.getSlowRequestThreshold();
        result = result * 59 + ($slowRequestThreshold == null ? 43 : ((Object)$slowRequestThreshold).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkOperatorConfiguration(reconcileInterval=" + this.getReconcileInterval() + ", reconcilerMaxParallelism=" + this.getReconcilerMaxParallelism() + ", progressCheckInterval=" + this.getProgressCheckInterval() + ", restApiReadyDelay=" + this.getRestApiReadyDelay() + ", flinkClientTimeout=" + this.getFlinkClientTimeout() + ", flinkServiceHostOverride=" + this.getFlinkServiceHostOverride() + ", watchedNamespaces=" + this.getWatchedNamespaces() + ", dynamicNamespacesEnabled=" + this.isDynamicNamespacesEnabled() + ", josdkMetricsEnabled=" + this.isJosdkMetricsEnabled() + ", metricsHistogramSampleSize=" + this.getMetricsHistogramSampleSize() + ", kubernetesClientMetricsEnabled=" + this.isKubernetesClientMetricsEnabled() + ", kubernetesClientMetricsHttpResponseCodeGroupsEnabled=" + this.isKubernetesClientMetricsHttpResponseCodeGroupsEnabled() + ", flinkCancelJobTimeout=" + this.getFlinkCancelJobTimeout() + ", flinkShutdownClusterTimeout=" + this.getFlinkShutdownClusterTimeout() + ", artifactsBaseDir=" + this.getArtifactsBaseDir() + ", savepointHistoryCountThreshold=" + this.getSavepointHistoryCountThreshold() + ", savepointHistoryAgeThreshold=" + this.getSavepointHistoryAgeThreshold() + ", retryConfiguration=" + this.getRetryConfiguration() + ", rateLimiter=" + this.getRateLimiter() + ", exceptionStackTraceEnabled=" + this.isExceptionStackTraceEnabled() + ", exceptionStackTraceLengthThreshold=" + this.getExceptionStackTraceLengthThreshold() + ", exceptionFieldLengthThreshold=" + this.getExceptionFieldLengthThreshold() + ", exceptionThrowableCountThreshold=" + this.getExceptionThrowableCountThreshold() + ", exceptionLabelMapper=" + this.getExceptionLabelMapper() + ", labelSelector=" + this.getLabelSelector() + ", leaderElectionConfiguration=" + this.getLeaderElectionConfiguration() + ", deletionPropagation=" + this.getDeletionPropagation() + ", snapshotResourcesEnabled=" + this.isSnapshotResourcesEnabled() + ", slowRequestThreshold=" + this.getSlowRequestThreshold() + ")";
    }
}

