/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.autoscaler.state;

import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.autoscaler.DelayedScaleDown;
import org.apache.flink.autoscaler.ScalingSummary;
import org.apache.flink.autoscaler.ScalingTracking;
import org.apache.flink.autoscaler.metrics.CollectedMetrics;
import org.apache.flink.autoscaler.state.AutoScalerStateStore;
import org.apache.flink.autoscaler.tuning.ConfigChanges;
import org.apache.flink.autoscaler.utils.AutoScalerSerDeModule;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.kubernetes.operator.autoscaler.KubernetesJobAutoScalerContext;
import org.apache.flink.kubernetes.operator.autoscaler.state.ConfigMapStore;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JacksonException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.apache.flink.shaded.jackson2.org.yaml.snakeyaml.LoaderOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesAutoScalerStateStore
implements AutoScalerStateStore<ResourceID, KubernetesJobAutoScalerContext> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesAutoScalerStateStore.class);
    @VisibleForTesting
    protected static final String SCALING_HISTORY_KEY = "scalingHistory";
    @VisibleForTesting
    protected static final String SCALING_TRACKING_KEY = "scalingTracking";
    @VisibleForTesting
    protected static final String COLLECTED_METRICS_KEY = "collectedMetrics";
    @VisibleForTesting
    protected static final String PARALLELISM_OVERRIDES_KEY = "parallelismOverrides";
    protected static final String CONFIG_OVERRIDES_KEY = "configOverrides";
    @VisibleForTesting
    protected static final String DELAYED_SCALE_DOWN = "delayedScaleDown";
    @VisibleForTesting
    protected static final int MAX_CM_BYTES = 1000000;
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)KubernetesAutoScalerStateStore.yamlFactory()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new AutoScalerSerDeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final ConfigMapStore configMapStore;

    public KubernetesAutoScalerStateStore(ConfigMapStore configMapStore) {
        this.configMapStore = configMapStore;
    }

    public void storeScalingHistory(KubernetesJobAutoScalerContext jobContext, Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        this.configMapStore.putSerializedState(jobContext, SCALING_HISTORY_KEY, KubernetesAutoScalerStateStore.serializeScalingHistory(scalingHistory));
    }

    public void storeScalingTracking(KubernetesJobAutoScalerContext jobContext, ScalingTracking scalingTrack) {
        this.configMapStore.putSerializedState(jobContext, SCALING_TRACKING_KEY, KubernetesAutoScalerStateStore.serializeScalingTracking(scalingTrack));
    }

    @Nonnull
    public Map<JobVertexID, SortedMap<Instant, ScalingSummary>> getScalingHistory(KubernetesJobAutoScalerContext jobContext) {
        Optional<String> serializedScalingHistory = this.configMapStore.getSerializedState(jobContext, SCALING_HISTORY_KEY);
        if (serializedScalingHistory.isEmpty()) {
            return new HashMap<JobVertexID, SortedMap<Instant, ScalingSummary>>();
        }
        try {
            return KubernetesAutoScalerStateStore.deserializeScalingHistory(serializedScalingHistory.get());
        }
        catch (JacksonException e) {
            LOG.error("Could not deserialize scaling history, possibly the format changed. Discarding...", (Throwable)e);
            this.configMapStore.removeSerializedState(jobContext, SCALING_HISTORY_KEY);
            return new HashMap<JobVertexID, SortedMap<Instant, ScalingSummary>>();
        }
    }

    public ScalingTracking getScalingTracking(KubernetesJobAutoScalerContext jobContext) {
        Optional<String> serializedRescalingHistory = this.configMapStore.getSerializedState(jobContext, SCALING_TRACKING_KEY);
        if (serializedRescalingHistory.isEmpty()) {
            return new ScalingTracking();
        }
        try {
            return KubernetesAutoScalerStateStore.deserializeScalingTracking(serializedRescalingHistory.get());
        }
        catch (JacksonException e) {
            LOG.error("Could not deseri alize rescaling history, possibly the format changed. Discarding...", (Throwable)e);
            this.configMapStore.removeSerializedState(jobContext, SCALING_TRACKING_KEY);
            return new ScalingTracking();
        }
    }

    public void removeScalingHistory(KubernetesJobAutoScalerContext jobContext) {
        this.configMapStore.removeSerializedState(jobContext, SCALING_HISTORY_KEY);
    }

    public void storeCollectedMetrics(KubernetesJobAutoScalerContext jobContext, SortedMap<Instant, CollectedMetrics> metrics) {
        this.configMapStore.putSerializedState(jobContext, COLLECTED_METRICS_KEY, KubernetesAutoScalerStateStore.serializeEvaluatedMetrics(metrics));
    }

    @Nonnull
    public SortedMap<Instant, CollectedMetrics> getCollectedMetrics(KubernetesJobAutoScalerContext jobContext) {
        Optional<String> serializedEvaluatedMetricsOpt = this.configMapStore.getSerializedState(jobContext, COLLECTED_METRICS_KEY);
        if (serializedEvaluatedMetricsOpt.isEmpty()) {
            return new TreeMap<Instant, CollectedMetrics>();
        }
        try {
            return KubernetesAutoScalerStateStore.deserializeEvaluatedMetrics(serializedEvaluatedMetricsOpt.get());
        }
        catch (JacksonException e) {
            LOG.error("Could not deserialize metric history, possibly the format changed. Discarding...", (Throwable)e);
            this.configMapStore.removeSerializedState(jobContext, COLLECTED_METRICS_KEY);
            return new TreeMap<Instant, CollectedMetrics>();
        }
    }

    public void removeCollectedMetrics(KubernetesJobAutoScalerContext jobContext) {
        this.configMapStore.removeSerializedState(jobContext, COLLECTED_METRICS_KEY);
    }

    public void storeParallelismOverrides(KubernetesJobAutoScalerContext jobContext, Map<String, String> parallelismOverrides) {
        this.configMapStore.putSerializedState(jobContext, PARALLELISM_OVERRIDES_KEY, KubernetesAutoScalerStateStore.serializeParallelismOverrides(parallelismOverrides));
    }

    @Nonnull
    public Map<String, String> getParallelismOverrides(KubernetesJobAutoScalerContext jobContext) {
        return this.configMapStore.getSerializedState(jobContext, PARALLELISM_OVERRIDES_KEY).map(KubernetesAutoScalerStateStore::deserializeParallelismOverrides).orElse(new HashMap());
    }

    @Nonnull
    public ConfigChanges getConfigChanges(KubernetesJobAutoScalerContext jobContext) {
        return this.configMapStore.getSerializedState(jobContext, CONFIG_OVERRIDES_KEY).map(KubernetesAutoScalerStateStore::deserializeConfigOverrides).orElse(new ConfigChanges());
    }

    public void storeConfigChanges(KubernetesJobAutoScalerContext jobContext, ConfigChanges overrides) {
        this.configMapStore.putSerializedState(jobContext, CONFIG_OVERRIDES_KEY, KubernetesAutoScalerStateStore.serializeConfigOverrides(overrides));
    }

    public void removeConfigChanges(KubernetesJobAutoScalerContext jobContext) {
        this.configMapStore.removeSerializedState(jobContext, CONFIG_OVERRIDES_KEY);
    }

    public void removeParallelismOverrides(KubernetesJobAutoScalerContext jobContext) {
        this.configMapStore.removeSerializedState(jobContext, PARALLELISM_OVERRIDES_KEY);
    }

    public void storeDelayedScaleDown(KubernetesJobAutoScalerContext jobContext, DelayedScaleDown delayedScaleDown) throws Exception {
        this.configMapStore.putSerializedState(jobContext, DELAYED_SCALE_DOWN, KubernetesAutoScalerStateStore.serializeDelayedScaleDown(delayedScaleDown));
    }

    @Nonnull
    public DelayedScaleDown getDelayedScaleDown(KubernetesJobAutoScalerContext jobContext) {
        Optional<String> delayedScaleDown = this.configMapStore.getSerializedState(jobContext, DELAYED_SCALE_DOWN);
        if (delayedScaleDown.isEmpty()) {
            return new DelayedScaleDown();
        }
        try {
            return KubernetesAutoScalerStateStore.deserializeDelayedScaleDown(delayedScaleDown.get());
        }
        catch (JacksonException e) {
            LOG.warn("Could not deserialize delayed scale down, possibly the format changed. Discarding...", (Throwable)e);
            this.configMapStore.removeSerializedState(jobContext, DELAYED_SCALE_DOWN);
            return new DelayedScaleDown();
        }
    }

    public void clearAll(KubernetesJobAutoScalerContext jobContext) {
        this.configMapStore.clearAll(jobContext);
    }

    public void flush(KubernetesJobAutoScalerContext jobContext) {
        this.trimHistoryToMaxCmSize(jobContext);
        this.configMapStore.flush(jobContext);
    }

    protected static String serializeScalingHistory(Map<JobVertexID, SortedMap<Instant, ScalingSummary>> scalingHistory) {
        return KubernetesAutoScalerStateStore.compress(YAML_MAPPER.writeValueAsString(scalingHistory));
    }

    private static Map<JobVertexID, SortedMap<Instant, ScalingSummary>> deserializeScalingHistory(String scalingHistory) throws JacksonException {
        return (Map)YAML_MAPPER.readValue(KubernetesAutoScalerStateStore.decompress(scalingHistory), (TypeReference)new TypeReference<Map<JobVertexID, SortedMap<Instant, ScalingSummary>>>(){});
    }

    protected static String serializeScalingTracking(ScalingTracking scalingTracking) {
        return KubernetesAutoScalerStateStore.compress(YAML_MAPPER.writeValueAsString((Object)scalingTracking));
    }

    private static ScalingTracking deserializeScalingTracking(String scalingTracking) throws JacksonException {
        return (ScalingTracking)YAML_MAPPER.readValue(KubernetesAutoScalerStateStore.decompress(scalingTracking), (TypeReference)new TypeReference<ScalingTracking>(){});
    }

    @VisibleForTesting
    protected static String serializeEvaluatedMetrics(SortedMap<Instant, CollectedMetrics> evaluatedMetrics) {
        return KubernetesAutoScalerStateStore.compress(YAML_MAPPER.writeValueAsString(evaluatedMetrics));
    }

    private static SortedMap<Instant, CollectedMetrics> deserializeEvaluatedMetrics(String evaluatedMetrics) throws JacksonException {
        return (SortedMap)YAML_MAPPER.readValue(KubernetesAutoScalerStateStore.decompress(evaluatedMetrics), (TypeReference)new TypeReference<SortedMap<Instant, CollectedMetrics>>(){});
    }

    private static String serializeParallelismOverrides(Map<String, String> overrides) {
        return (String)ConfigurationUtils.convertValue(overrides, String.class);
    }

    private static Map<String, String> deserializeParallelismOverrides(String overrides) {
        return (Map)ConfigurationUtils.convertValue((Object)overrides, Map.class);
    }

    @Nullable
    private static String serializeConfigOverrides(ConfigChanges configChanges) {
        try {
            return YAML_MAPPER.writeValueAsString((Object)configChanges);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize ConfigOverrides", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ConfigChanges deserializeConfigOverrides(String configOverrides) {
        try {
            return (ConfigChanges)YAML_MAPPER.readValue(configOverrides, (TypeReference)new TypeReference<ConfigChanges>(){});
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize ConfigOverrides", (Throwable)e);
            return null;
        }
    }

    private static String serializeDelayedScaleDown(DelayedScaleDown delayedScaleDown) throws JacksonException {
        return YAML_MAPPER.writeValueAsString((Object)delayedScaleDown);
    }

    private static DelayedScaleDown deserializeDelayedScaleDown(String delayedScaleDown) throws JacksonException {
        return (DelayedScaleDown)YAML_MAPPER.readValue(delayedScaleDown, (TypeReference)new TypeReference<DelayedScaleDown>(){});
    }

    @VisibleForTesting
    protected void trimHistoryToMaxCmSize(KubernetesJobAutoScalerContext context) {
        int scalingHistorySize = this.configMapStore.getSerializedState(context, SCALING_HISTORY_KEY).map(String::length).orElse(0);
        int scalingTrackingSize = this.configMapStore.getSerializedState(context, SCALING_TRACKING_KEY).map(String::length).orElse(0);
        int metricHistorySize = this.configMapStore.getSerializedState(context, COLLECTED_METRICS_KEY).map(String::length).orElse(0);
        SortedMap<Instant, CollectedMetrics> metricHistory = this.getCollectedMetrics(context);
        while (scalingHistorySize + metricHistorySize + scalingTrackingSize > 1000000) {
            if (metricHistory.isEmpty()) {
                return;
            }
            Instant firstKey = metricHistory.firstKey();
            LOG.info("Trimming metric history by removing {}", (Object)firstKey);
            metricHistory.remove(firstKey);
            String compressed = KubernetesAutoScalerStateStore.serializeEvaluatedMetrics(metricHistory);
            this.configMapStore.putSerializedState(context, COLLECTED_METRICS_KEY, compressed);
            metricHistorySize = compressed.length();
        }
    }

    private static String compress(String original) throws IOException {
        ByteArrayOutputStream rstBao = new ByteArrayOutputStream();
        try (GZIPOutputStream zos = new GZIPOutputStream(rstBao);){
            zos.write(original.getBytes(StandardCharsets.UTF_8));
        }
        return Base64.getEncoder().encodeToString(rstBao.toByteArray());
    }

    private static String decompress(String compressed) {
        String string;
        if (compressed == null) {
            return null;
        }
        byte[] bytes = Base64.getDecoder().decode(compressed);
        GZIPInputStream zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
        try {
            string = IOUtils.toString((InputStream)zi, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zi.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("Error while decompressing scaling data, treating as uncompressed");
                return compressed;
            }
        }
        zi.close();
        return string;
    }

    private static YAMLFactory yamlFactory() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x1400000);
        return YAMLFactory.builder().loaderOptions(loaderOptions).build();
    }

    public void close() throws Exception {
    }
}

