/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.artifact;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.File;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.operator.api.spec.FlinkSessionJobSpec;
import org.apache.flink.kubernetes.operator.artifact.FileSystemBasedArtifactFetcher;
import org.apache.flink.kubernetes.operator.artifact.HttpArtifactFetcher;
import org.apache.flink.kubernetes.operator.config.FlinkConfigManager;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactManager {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactManager.class);
    private final FlinkConfigManager configManager;

    public ArtifactManager(FlinkConfigManager configManager) {
        this.configManager = configManager;
    }

    private synchronized void createIfNotExists(File targetDir) {
        if (!targetDir.exists()) {
            try {
                FileUtils.forceMkdirParent((File)targetDir);
                LOG.info("Created dir: {}", (Object)targetDir);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException(String.format("Failed to create the dir: %s", targetDir), (Throwable)e);
            }
        }
    }

    public File fetch(String jarURI, Configuration flinkConfiguration, String targetDirStr) throws Exception {
        File targetDir = new File(targetDirStr);
        this.createIfNotExists(targetDir);
        URI uri = new URI(jarURI);
        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
            return HttpArtifactFetcher.INSTANCE.fetch(jarURI, flinkConfiguration, targetDir);
        }
        return FileSystemBasedArtifactFetcher.INSTANCE.fetch(jarURI, flinkConfiguration, targetDir);
    }

    public String generateJarDir(ObjectMeta meta, FlinkSessionJobSpec spec) {
        return String.join((CharSequence)File.separator, new File(this.configManager.getOperatorConfiguration().getArtifactsBaseDir()).getAbsolutePath(), meta.getNamespace(), spec.getDeploymentName(), meta.getName());
    }
}

